/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class DeleteParam {
    protected final String databaseName;
    private final String collectionName;
    private final String partitionName;
    private final String expr;

    private DeleteParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.expr = builder.expr;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public String getExpr() {
        return this.expr;
    }

    public String toString() {
        return "DeleteParam(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ", partitionName=" + this.getPartitionName() + ", expr=" + this.getExpr() + ")";
    }

    public static class Builder {
        private String databaseName;
        private String collectionName;
        private String partitionName = "";
        private String expr;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public Builder withExpr(@NonNull String expr) {
            if (expr == null) {
                throw new NullPointerException("expr is marked non-null but is null");
            }
            this.expr = expr;
            return this;
        }

        public DeleteParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.expr, "Expression");
            return new DeleteParam(this);
        }
    }
}

