/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.sdk.autoconfigure.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.HashMap;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;

final class SpiUtil {
    static <T, U> NamedSpiManager<T> loadConfigurable(Class<U> spiClass, Function<U, String> getName, BiFunction<U, ConfigProperties, T> getConfigurable, ConfigProperties config, ClassLoader serviceClassLoader) {
        return SpiUtil.loadConfigurable(spiClass, getName, getConfigurable, config, serviceClassLoader, ServiceLoader::load);
    }

    static <T, U> NamedSpiManager<T> loadConfigurable(Class<U> spiClass, Function<U, String> getName, BiFunction<U, ConfigProperties, T> getConfigurable, ConfigProperties config, ClassLoader serviceClassLoader, ServiceLoaderFinder serviceLoaderFinder) {
        HashMap nameToProvider = new HashMap();
        for (Object provider : serviceLoaderFinder.load(spiClass, serviceClassLoader)) {
            String name = getName.apply(provider);
            nameToProvider.put(name, () -> getConfigurable.apply(provider, config));
        }
        return NamedSpiManager.create(nameToProvider);
    }

    private SpiUtil() {
    }

    static interface ServiceLoaderFinder {
        public <S> Iterable<S> load(Class<S> var1, ClassLoader var2);
    }
}

