/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BoundDoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleCounterBuilder;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.SdkLongCounter;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

final class SdkDoubleCounter
extends AbstractInstrument
implements DoubleCounter {
    private final WriteableMetricStorage storage;

    private SdkDoubleCounter(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(double increment, Attributes attributes, Context context) {
        BoundStorageHandle aggregatorHandle = this.storage.bind(attributes);
        try {
            if (increment < 0.0) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            aggregatorHandle.recordDouble(increment, attributes, context);
        }
        finally {
            aggregatorHandle.release();
        }
    }

    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    public BoundDoubleCounter bind(Attributes attributes) {
        return new BoundInstrument(this.storage.bind(attributes), attributes);
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements DoubleCounterBuilder {
        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this(meterProviderSharedState, meterSharedState, name, "", "1");
        }

        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, name, description, unit);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SdkDoubleCounter build() {
            return this.buildSynchronousInstrument(InstrumentType.COUNTER, InstrumentValueType.DOUBLE, (x$0, x$1) -> new SdkDoubleCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        public LongCounterBuilder ofLongs() {
            return this.swapBuilder(SdkLongCounter.Builder::new);
        }

        public void buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            this.registerDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_SUM, callback);
        }
    }

    static final class BoundInstrument
    implements BoundDoubleCounter {
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(BoundStorageHandle handle, Attributes attributes) {
            this.handle = handle;
            this.attributes = attributes;
        }

        public void add(double increment, Context context) {
            if (increment < 0.0) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            this.handle.recordDouble(increment, this.attributes, context);
        }

        public void add(double increment) {
            this.add(increment, Context.current());
        }

        public void unbind() {
            this.handle.release();
        }
    }
}

