/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.internal.view.ViewRegistry;
import io.opentelemetry.sdk.metrics.internal.view.ViewRegistryBuilder;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import io.opentelemetry.sdk.metrics.view.View;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Objects;

public final class SdkMeterProviderBuilder {
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final ViewRegistryBuilder viewRegistryBuilder = ViewRegistry.builder();

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull(selector, "selector");
        Objects.requireNonNull(view, "view");
        this.viewRegistryBuilder.addView(selector, view);
        return this;
    }

    public SdkMeterProvider buildAndRegisterGlobal() {
        SdkMeterProvider meterProvider = this.build();
        GlobalMeterProvider.set((MeterProvider)meterProvider);
        return meterProvider;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.clock, this.resource, this.viewRegistryBuilder.build());
    }
}

