/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.connection;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopScopeManager;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.function.Supplier;

class RedisTracingUtils {
    private static final StringTag COMMAND_TAG = new StringTag("command");
    private static final String REDIS_COMMAND = "RedisCommand";

    RedisTracingUtils() {
    }

    static <T> T doInScope(String command, Supplier<T> supplier, boolean withActiveSpanOnly, Tracer tracer) {
        try (Scope scope = RedisTracingUtils.buildScope(command, withActiveSpanOnly, tracer);){
            T t = supplier.get();
            return t;
        }
    }

    private static Scope buildScope(String command, boolean withActiveSpanOnly, Tracer tracer) {
        Tracer currentTracer = RedisTracingUtils.getNullSafeTracer(tracer);
        if (withActiveSpanOnly && currentTracer.activeSpan() == null) {
            return NoopScopeManager.NoopScope.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = currentTracer.buildSpan(REDIS_COMMAND).withTag(Tags.SPAN_KIND.getKey(), "client");
        Scope scope = spanBuilder.startActive(true);
        RedisTracingUtils.decorate(scope.span(), command);
        return scope;
    }

    private static Tracer getNullSafeTracer(Tracer tracer) {
        if (tracer == null) {
            return GlobalTracer.get();
        }
        return tracer;
    }

    private static void decorate(Span span, String command) {
        Tags.COMPONENT.set(span, "java-redis");
        COMMAND_TAG.set(span, command);
    }
}

