/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.connection;

import io.opentracing.Tracer;
import io.opentracing.contrib.redis.spring.connection.TracingRedisConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.types.RedisClientInfo;

public class TracingRedisClusterConnection
extends TracingRedisConnection
implements RedisClusterConnection {
    private final RedisClusterConnection connection;

    public TracingRedisClusterConnection(RedisClusterConnection connection, boolean withActiveSpanOnly, Tracer tracer) {
        super((RedisConnection)connection, withActiveSpanOnly, tracer);
        this.connection = connection;
    }

    public RedisClusterServerCommands serverCommands() {
        return this.connection.serverCommands();
    }

    public Iterable<RedisClusterNode> clusterGetNodes() {
        return this.doInScope("CLUSTER NODES", () -> this.connection.clusterGetNodes());
    }

    public Collection<RedisClusterNode> clusterGetSlaves(RedisClusterNode master) {
        return this.doInScope("CLUSTER SLAVES", () -> this.connection.clusterGetSlaves(master));
    }

    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterSlaveMap() {
        return this.doInScope("CLUSTER MASTER-SLAVE-MAP", () -> this.connection.clusterGetMasterSlaveMap());
    }

    public Integer clusterGetSlotForKey(byte[] key) {
        return this.doInScope("CLUSTER KEYSLOT", () -> this.connection.clusterGetSlotForKey(key));
    }

    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        return this.doInScope("CLUSTER_NODE_FOR_SLOT", () -> this.connection.clusterGetNodeForSlot(slot));
    }

    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        return this.doInScope("CLUSTER_NODE_FOR_KEY", () -> this.connection.clusterGetNodeForKey(key));
    }

    public ClusterInfo clusterGetClusterInfo() {
        return this.doInScope("CLUSTER INFO", () -> this.connection.clusterGetClusterInfo());
    }

    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        this.doInScope("CLUSTER ADDSLOTS", () -> this.connection.clusterAddSlots(node, slots));
    }

    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.doInScope("CLUSTER ADDSLOTS", () -> this.connection.clusterAddSlots(node, range));
    }

    public Long clusterCountKeysInSlot(int slot) {
        return this.doInScope("CLUSTER COUNTKEYSINSLOT", () -> this.connection.clusterCountKeysInSlot(slot));
    }

    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        this.doInScope("CLUSTER DELSLOTS", () -> this.connection.clusterDeleteSlots(node, slots));
    }

    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.doInScope("CLUSTER DELSLOTS", () -> this.connection.clusterDeleteSlotsInRange(node, range));
    }

    public void clusterForget(RedisClusterNode node) {
        this.doInScope("CLUSTER FORGET", () -> this.connection.clusterForget(node));
    }

    public void clusterMeet(RedisClusterNode node) {
        this.doInScope("CLUSTER MEET", () -> this.connection.clusterMeet(node));
    }

    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        this.doInScope("CLUSTER SETSLOT", () -> this.connection.clusterSetSlot(node, slot, mode));
    }

    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        return this.doInScope("CLUSTER GETKEYSINSLOT", () -> this.connection.clusterGetKeysInSlot(slot, count));
    }

    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        this.doInScope("CLUSTER REPLICATE", () -> this.connection.clusterReplicate(master, slave));
    }

    public String ping(RedisClusterNode node) {
        return this.doInScope("PING", () -> this.connection.ping(node));
    }

    public void bgReWriteAof(RedisClusterNode node) {
        this.doInScope("BGREWRITEAOF", () -> this.connection.bgReWriteAof(node));
    }

    public void bgSave(RedisClusterNode node) {
        this.doInScope("BGSAVE", () -> this.connection.bgSave(node));
    }

    public Long lastSave(RedisClusterNode node) {
        return this.doInScope("LASTSAVE", () -> this.connection.lastSave(node));
    }

    public void save(RedisClusterNode node) {
        this.doInScope("SAVE", () -> this.connection.save(node));
    }

    public Long dbSize(RedisClusterNode node) {
        return this.doInScope("DBSIZE", () -> this.connection.dbSize(node));
    }

    public void flushDb(RedisClusterNode node) {
        this.doInScope("FLUSHDB", () -> this.connection.flushDb(node));
    }

    public void flushAll(RedisClusterNode node) {
        this.doInScope("FLUSHALL", () -> this.connection.flushAll(node));
    }

    public Properties info(RedisClusterNode node) {
        return this.doInScope("INFO", () -> this.connection.info(node));
    }

    public Properties info(RedisClusterNode node, String section) {
        return this.doInScope("INFO", () -> this.connection.info(node, section));
    }

    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        return this.doInScope("KEYS", () -> this.connection.keys(node, pattern));
    }

    public byte[] randomKey(RedisClusterNode node) {
        return this.doInScope("RANDOMKEY", () -> this.connection.randomKey(node));
    }

    public void shutdown(RedisClusterNode node) {
        this.doInScope("SHUTDOWN", () -> this.connection.shutdown(node));
    }

    public Properties getConfig(RedisClusterNode node, String pattern) {
        return this.doInScope("CONFIG GET", () -> this.connection.getConfig(node, pattern));
    }

    public void setConfig(RedisClusterNode node, String param, String value) {
        this.doInScope("CONFIG SET", () -> this.connection.setConfig(node, param, value));
    }

    public void resetConfigStats(RedisClusterNode node) {
        this.doInScope("CONFIG RESETSTAT", () -> this.connection.resetConfigStats(node));
    }

    public Long time(RedisClusterNode node) {
        return this.doInScope("TIME", () -> this.connection.time(node));
    }

    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        return this.doInScope("CLIENT LIST", () -> this.connection.getClientList(node));
    }
}

