/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.connection;

import io.opentracing.Tracer;
import io.opentracing.contrib.redis.spring.connection.RedisTracingUtils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.dao.DataAccessException;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;

public class TracingRedisConnection
implements RedisConnection {
    private final RedisConnection connection;
    private final boolean withActiveSpanOnly;
    private final Tracer tracer;

    public TracingRedisConnection(RedisConnection connection, boolean withActiveSpanOnly, Tracer tracer) {
        this.connection = connection;
        this.withActiveSpanOnly = withActiveSpanOnly;
        this.tracer = tracer;
    }

    <T> T doInScope(String command, Supplier<T> supplier) {
        return RedisTracingUtils.doInScope(command, supplier, this.withActiveSpanOnly, this.tracer);
    }

    void doInScope(String command, Runnable action) {
        this.doInScope(command, () -> {
            action.run();
            return null;
        });
    }

    public RedisGeoCommands geoCommands() {
        return this.connection.geoCommands();
    }

    public RedisHashCommands hashCommands() {
        return this.connection.hashCommands();
    }

    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return this.connection.hyperLogLogCommands();
    }

    public RedisKeyCommands keyCommands() {
        return this.connection.keyCommands();
    }

    public RedisListCommands listCommands() {
        return this.connection.listCommands();
    }

    public RedisSetCommands setCommands() {
        return this.connection.setCommands();
    }

    public RedisScriptingCommands scriptingCommands() {
        return this.connection.scriptingCommands();
    }

    public RedisServerCommands serverCommands() {
        return this.connection.serverCommands();
    }

    public RedisStringCommands stringCommands() {
        return this.connection.stringCommands();
    }

    public RedisZSetCommands zSetCommands() {
        return this.connection.zSetCommands();
    }

    public void close() throws DataAccessException {
        this.connection.close();
    }

    public boolean isClosed() {
        return this.connection.isClosed();
    }

    public Object getNativeConnection() {
        return this.connection.getNativeConnection();
    }

    public boolean isQueueing() {
        return this.connection.isQueueing();
    }

    public boolean isPipelined() {
        return this.connection.isPipelined();
    }

    public void openPipeline() {
        this.connection.openPipeline();
    }

    public List<Object> closePipeline() throws RedisPipelineException {
        return this.connection.closePipeline();
    }

    public boolean isSubscribed() {
        return this.connection.isSubscribed();
    }

    public Subscription getSubscription() {
        return this.connection.getSubscription();
    }

    public RedisSentinelConnection getSentinelConnection() {
        return this.connection.getSentinelConnection();
    }

    public Object execute(String command, byte[] ... args) {
        return this.doInScope(command, () -> this.connection.execute(command, args));
    }

    public Boolean exists(byte[] key) {
        return this.doInScope("EXISTS", () -> this.connection.exists(key));
    }

    public Long del(byte[] ... keys) {
        return this.doInScope("DEL", () -> this.connection.del(keys));
    }

    public DataType type(byte[] key) {
        return this.doInScope("TYPE", () -> this.connection.type(key));
    }

    public Set<byte[]> keys(byte[] pattern) {
        return this.doInScope("KEYS", () -> this.connection.keys(pattern));
    }

    public Cursor<byte[]> scan(ScanOptions options) {
        return this.doInScope("SCAN", () -> this.connection.scan(options));
    }

    public byte[] randomKey() {
        return this.doInScope("RANDOMKEY", () -> this.connection.randomKey());
    }

    public void rename(byte[] oldName, byte[] newName) {
        this.doInScope("RENAME", () -> this.connection.rename(oldName, newName));
    }

    public Boolean renameNX(byte[] oldName, byte[] newName) {
        return this.doInScope("RENAMENX", () -> this.connection.renameNX(oldName, newName));
    }

    public Boolean expire(byte[] key, long seconds) {
        return this.doInScope("EXPIRE", () -> this.connection.expire(key, seconds));
    }

    public Boolean pExpire(byte[] key, long millis) {
        return this.doInScope("PEXPIRE", () -> this.connection.pExpire(key, millis));
    }

    public Boolean expireAt(byte[] key, long unixTime) {
        return this.doInScope("EXPIREAT", () -> this.connection.expireAt(key, unixTime));
    }

    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        return this.doInScope("PEXPIREAT", () -> this.connection.pExpireAt(key, unixTimeInMillis));
    }

    public Boolean persist(byte[] key) {
        return this.doInScope("PERSIST", () -> this.connection.persist(key));
    }

    public Boolean move(byte[] key, int dbIndex) {
        return this.doInScope("MOVE", () -> this.connection.move(key, dbIndex));
    }

    public Long ttl(byte[] key) {
        return this.doInScope("TTL", () -> this.connection.ttl(key));
    }

    public Long ttl(byte[] key, TimeUnit timeUnit) {
        return this.doInScope("TTL", () -> this.connection.ttl(key, timeUnit));
    }

    public Long pTtl(byte[] key) {
        return this.doInScope("PTTL", () -> this.connection.pTtl(key));
    }

    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        return this.doInScope("PTTL", () -> this.connection.pTtl(key, timeUnit));
    }

    public List<byte[]> sort(byte[] key, SortParameters params) {
        return this.doInScope("SORT", () -> this.connection.sort(key, params));
    }

    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        return this.doInScope("SORT", () -> this.connection.sort(key, params, storeKey));
    }

    public byte[] dump(byte[] key) {
        return this.doInScope("DUMP", () -> this.connection.dump(key));
    }

    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        this.doInScope("RESTORE", () -> this.connection.restore(key, ttlInMillis, serializedValue));
    }

    public byte[] get(byte[] key) {
        return this.doInScope("GET", () -> this.connection.get(key));
    }

    public byte[] getSet(byte[] key, byte[] value) {
        return this.doInScope("GETSET", () -> this.connection.getSet(key, value));
    }

    public List<byte[]> mGet(byte[] ... keys) {
        return this.doInScope("MGET", () -> this.connection.mGet(keys));
    }

    public Boolean set(byte[] key, byte[] value) {
        return this.doInScope("SET", () -> this.connection.set(key, value));
    }

    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        return this.doInScope("SET", () -> this.connection.set(key, value, expiration, option));
    }

    public Boolean setNX(byte[] key, byte[] value) {
        return this.doInScope("SETNX", () -> this.connection.setNX(key, value));
    }

    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        return this.doInScope("SETEX", () -> this.connection.setEx(key, seconds, value));
    }

    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        return this.doInScope("PSETEX", () -> this.connection.pSetEx(key, milliseconds, value));
    }

    public Boolean mSet(Map<byte[], byte[]> tuple) {
        return this.doInScope("MSET", () -> this.connection.mSet(tuple));
    }

    public Boolean mSetNX(Map<byte[], byte[]> tuple) {
        return this.doInScope("MSETNX", () -> this.connection.mSetNX(tuple));
    }

    public Long incr(byte[] key) {
        return this.doInScope("INCR", () -> this.connection.incr(key));
    }

    public Long incrBy(byte[] key, long value) {
        return this.doInScope("INCRBY", () -> this.connection.incrBy(key, value));
    }

    public Double incrBy(byte[] key, double value) {
        return this.doInScope("INCRBY", () -> this.connection.incrBy(key, value));
    }

    public Long decr(byte[] key) {
        return this.doInScope("DECR", () -> this.connection.decr(key));
    }

    public Long decrBy(byte[] key, long value) {
        return this.doInScope("DECRBY", () -> this.connection.decrBy(key, value));
    }

    public Long append(byte[] key, byte[] value) {
        return this.doInScope("APPEND", () -> this.connection.append(key, value));
    }

    public byte[] getRange(byte[] key, long begin, long end) {
        return this.doInScope("GETRANGE", () -> this.connection.getRange(key, begin, end));
    }

    public void setRange(byte[] key, byte[] value, long offset) {
        this.doInScope("SETRANGE", () -> this.connection.setRange(key, value, offset));
    }

    public Boolean getBit(byte[] key, long offset) {
        return this.doInScope("GETBIT", () -> this.connection.getBit(key, offset));
    }

    public Boolean setBit(byte[] key, long offset, boolean value) {
        return this.doInScope("SETBIT", () -> this.connection.setBit(key, offset, value));
    }

    public Long bitCount(byte[] key) {
        return this.doInScope("BITCOUNT", () -> this.connection.bitCount(key));
    }

    public Long bitCount(byte[] key, long begin, long end) {
        return this.doInScope("BITCOUNT", () -> this.connection.bitCount(key, begin, end));
    }

    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        return this.doInScope("BITOP", () -> this.connection.bitOp(op, destination, keys));
    }

    public Long strLen(byte[] key) {
        return this.doInScope("STRLEN", () -> this.connection.strLen(key));
    }

    public Long rPush(byte[] key, byte[] ... values) {
        return this.doInScope("RPUSH", () -> this.connection.rPush(key, values));
    }

    public Long lPush(byte[] key, byte[] ... values) {
        return this.doInScope("LPUSH", () -> this.connection.lPush(key, values));
    }

    public Long rPushX(byte[] key, byte[] value) {
        return this.doInScope("RPUSHX", () -> this.connection.rPushX(key, value));
    }

    public Long lPushX(byte[] key, byte[] value) {
        return this.doInScope("LPUSHX", () -> this.connection.lPushX(key, value));
    }

    public Long lLen(byte[] key) {
        return this.doInScope("LLEN", () -> this.connection.lLen(key));
    }

    public List<byte[]> lRange(byte[] key, long start, long end) {
        return this.doInScope("LRANGE", () -> this.connection.lRange(key, start, end));
    }

    public void lTrim(byte[] key, long start, long end) {
        this.doInScope("LTRIM", () -> this.connection.lTrim(key, start, end));
    }

    public byte[] lIndex(byte[] key, long index) {
        return this.doInScope("LINDEX", () -> this.connection.lIndex(key, index));
    }

    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        return this.doInScope("LINSERT", () -> this.connection.lInsert(key, where, pivot, value));
    }

    public void lSet(byte[] key, long index, byte[] value) {
        this.doInScope("LSET", () -> this.connection.lSet(key, index, value));
    }

    public Long lRem(byte[] key, long count, byte[] value) {
        return this.doInScope("LREM", () -> this.connection.lRem(key, count, value));
    }

    public byte[] lPop(byte[] key) {
        return this.doInScope("LPOP", () -> this.connection.lPop(key));
    }

    public byte[] rPop(byte[] key) {
        return this.doInScope("RPOP", () -> this.connection.rPop(key));
    }

    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        return this.doInScope("BLPOP", () -> this.connection.bLPop(timeout, keys));
    }

    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        return this.doInScope("BRPOP", () -> this.connection.bRPop(timeout, keys));
    }

    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        return this.doInScope("RPOPLPUSH", () -> this.connection.rPopLPush(srcKey, dstKey));
    }

    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        return this.doInScope("BRPOPLPUSH", () -> this.connection.bRPopLPush(timeout, srcKey, dstKey));
    }

    public Long sAdd(byte[] key, byte[] ... values) {
        return this.doInScope("SADD", () -> this.connection.sAdd(key, values));
    }

    public Long sRem(byte[] key, byte[] ... values) {
        return this.doInScope("SREM", () -> this.connection.sRem(key, values));
    }

    public byte[] sPop(byte[] key) {
        return this.doInScope("SPOP", () -> this.connection.sPop(key));
    }

    public List<byte[]> sPop(byte[] key, long count) {
        return this.doInScope("SPOP", () -> this.connection.sPop(key, count));
    }

    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        return this.doInScope("SMOVE", () -> this.connection.sMove(srcKey, destKey, value));
    }

    public Long sCard(byte[] key) {
        return this.doInScope("SCARD", () -> this.connection.sCard(key));
    }

    public Boolean sIsMember(byte[] key, byte[] value) {
        return this.doInScope("SISMEMBER", () -> this.connection.sIsMember(key, value));
    }

    public Set<byte[]> sInter(byte[] ... keys) {
        return this.doInScope("SINTER", () -> this.connection.sInter(keys));
    }

    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        return this.doInScope("SINTERSTORE", () -> this.connection.sInterStore(destKey, keys));
    }

    public Set<byte[]> sUnion(byte[] ... keys) {
        return this.doInScope("SUNION", () -> this.connection.sUnion(keys));
    }

    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        return this.doInScope("SUNIONSTORE", () -> this.connection.sUnionStore(destKey, keys));
    }

    public Set<byte[]> sDiff(byte[] ... keys) {
        return this.doInScope("SDIFF", () -> this.connection.sDiff(keys));
    }

    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        return this.doInScope("SDIFFSTORE", () -> this.connection.sDiffStore(destKey, keys));
    }

    public Set<byte[]> sMembers(byte[] key) {
        return this.doInScope("SMEMBERS", () -> this.connection.sMembers(key));
    }

    public byte[] sRandMember(byte[] key) {
        return this.doInScope("SRANDMEMBER", () -> this.connection.sRandMember(key));
    }

    public List<byte[]> sRandMember(byte[] key, long count) {
        return this.doInScope("SRANDMEMBER", () -> this.connection.sRandMember(key, count));
    }

    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return this.doInScope("SSCAN", () -> this.connection.sScan(key, options));
    }

    public Boolean zAdd(byte[] key, double score, byte[] value) {
        return this.doInScope("ZADD", () -> this.connection.zAdd(key, score, value));
    }

    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        return this.doInScope("ZADD", () -> this.connection.zAdd(key, tuples));
    }

    public Long zRem(byte[] key, byte[] ... values) {
        return this.doInScope("ZREM", () -> this.connection.zRem(key, values));
    }

    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        return this.doInScope("ZINCRBY", () -> this.connection.zIncrBy(key, increment, value));
    }

    public Long zRank(byte[] key, byte[] value) {
        return this.doInScope("ZRANK", () -> this.connection.zRank(key, value));
    }

    public Long zRevRank(byte[] key, byte[] value) {
        return this.doInScope("ZREVRANK", () -> this.connection.zRevRank(key, value));
    }

    public Set<byte[]> zRange(byte[] key, long start, long end) {
        return this.doInScope("ZRANGE", () -> this.connection.zRange(key, start, end));
    }

    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        return this.doInScope("ZREVRANGE", () -> this.connection.zRevRange(key, start, end));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        return this.doInScope("ZREVRANGE WITHSCORES", () -> this.connection.zRevRangeWithScores(key, start, end));
    }

    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        return this.doInScope("ZRANGE WITHSCORES", () -> this.connection.zRangeWithScores(key, start, end));
    }

    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        return this.doInScope("ZRANGEBYSCORE", () -> this.connection.zRangeByScore(key, min, max));
    }

    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.doInScope("ZRANGEBYSCORE", () -> this.connection.zRangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return this.doInScope("ZRANGEBYSCORE", () -> this.connection.zRangeByScore(key, min, max));
    }

    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return this.doInScope("ZRANGEBYSCORE", () -> this.connection.zRangeByScore(key, range));
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        return this.doInScope("ZRANGEBYSCORE", () -> this.connection.zRangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return this.doInScope("ZRANGEBYSCORE", () -> this.connection.zRangeByScore(key, range, limit));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return this.doInScope("ZRANGEBYSCORE WITHSCORES", () -> this.connection.zRangeByScoreWithScores(key, range));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.doInScope("ZRANGEBYSCORE WITHSCORES", () -> this.connection.zRangeByScoreWithScores(key, min, max));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.doInScope("ZRANGEBYSCORE WITHSCORES", () -> this.connection.zRangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return this.doInScope("ZRANGEBYSCORE WITHSCORES", () -> this.connection.zRangeByScoreWithScores(key, range, limit));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.doInScope("ZREVRANGEBYSCORE", () -> this.connection.zRevRangeByScore(key, min, max));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return this.doInScope("ZREVRANGEBYSCORE", () -> this.connection.zRevRangeByScore(key, range));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        return this.doInScope("ZREVRANGEBYSCORE", () -> this.connection.zRevRangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return this.doInScope("ZREVRANGEBYSCORE", () -> this.connection.zRevRangeByScore(key, range, limit));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        return this.doInScope("ZREVRANGEBYSCORE WITHSCORES", () -> this.connection.zRevRangeByScoreWithScores(key, min, max));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        return this.doInScope("ZREVRANGEBYSCORE WITHSCORES", () -> this.connection.zRevRangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range) {
        return this.doInScope("ZREVRANGEBYSCORE WITHSCORES", () -> this.connection.zRevRangeByScoreWithScores(key, range));
    }

    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return this.doInScope("ZREVRANGEBYSCORE WITHSCORES", () -> this.connection.zRevRangeByScoreWithScores(key, range, limit));
    }

    public Long zCount(byte[] key, double min, double max) {
        return this.doInScope("ZCOUNT", () -> this.connection.zCount(key, min, max));
    }

    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        return this.doInScope("ZCOUNT", () -> this.connection.zCount(key, range));
    }

    public Long zCard(byte[] key) {
        return this.doInScope("ZCARD", () -> this.connection.zCard(key));
    }

    public Double zScore(byte[] key, byte[] value) {
        return this.doInScope("ZSCORE", () -> this.connection.zScore(key, value));
    }

    public Long zRemRange(byte[] key, long start, long end) {
        return this.doInScope("ZREMRANGE", () -> this.connection.zRemRange(key, start, end));
    }

    public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.doInScope("ZREMRANGEBYSCORE", () -> this.connection.zRemRangeByScore(key, min, max));
    }

    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        return this.doInScope("ZREMRANGEBYSCORE", () -> this.connection.zRemRangeByScore(key, range));
    }

    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        return this.doInScope("ZUNIONSTORE", () -> this.connection.zUnionStore(destKey, sets));
    }

    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.doInScope("ZUNIONSTORE", () -> this.connection.zUnionStore(destKey, aggregate, weights, sets));
    }

    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        return this.doInScope("ZINTERSTORE", () -> this.connection.zInterStore(destKey, sets));
    }

    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        return this.doInScope("ZINTERSTORE", () -> this.connection.zInterStore(destKey, aggregate, weights, sets));
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.doInScope("ZSCAN", () -> this.connection.zScan(key, options));
    }

    public Set<byte[]> zRangeByLex(byte[] key) {
        return this.doInScope("ZRANGEBYLEX", () -> this.connection.zRangeByLex(key));
    }

    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range) {
        return this.doInScope("ZRANGEBYLEX", () -> this.connection.zRangeByLex(key, range));
    }

    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        return this.doInScope("ZRANGEBYLEX", () -> this.connection.zRangeByLex(key, range, limit));
    }

    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        return this.doInScope("HSET", () -> this.connection.hSet(key, field, value));
    }

    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        return this.doInScope("HSETNX", () -> this.connection.hSetNX(key, field, value));
    }

    public byte[] hGet(byte[] key, byte[] field) {
        return this.doInScope("HGET", () -> this.connection.hGet(key, field));
    }

    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        return this.doInScope("HMGET", () -> this.connection.hMGet(key, fields));
    }

    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        this.doInScope("HMSET", () -> this.connection.hMSet(key, hashes));
    }

    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        return this.doInScope("HINCRBY", () -> this.connection.hIncrBy(key, field, delta));
    }

    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        return this.doInScope("HINCRBY", () -> this.connection.hIncrBy(key, field, delta));
    }

    public Boolean hExists(byte[] key, byte[] field) {
        return this.doInScope("HEXISTS", () -> this.connection.hExists(key, field));
    }

    public Long hDel(byte[] key, byte[] ... fields) {
        return this.doInScope("HDEL", () -> this.connection.hDel(key, fields));
    }

    public Long hLen(byte[] key) {
        return this.doInScope("HLEN", () -> this.connection.hLen(key));
    }

    public Set<byte[]> hKeys(byte[] key) {
        return this.doInScope("HKEYS", () -> this.connection.hKeys(key));
    }

    public List<byte[]> hVals(byte[] key) {
        return this.doInScope("HVALS", () -> this.connection.hVals(key));
    }

    public Map<byte[], byte[]> hGetAll(byte[] key) {
        return this.doInScope("HGETALL", () -> this.connection.hGetAll(key));
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return this.doInScope("HSCAN", () -> this.connection.hScan(key, options));
    }

    public void multi() {
        this.doInScope("MULTI", () -> this.connection.multi());
    }

    public List<Object> exec() {
        return this.doInScope("EXEC", () -> this.connection.exec());
    }

    public void discard() {
        this.doInScope("DISCARD", () -> this.connection.discard());
    }

    public void watch(byte[] ... keys) {
        this.doInScope("WATCH", () -> this.connection.watch(keys));
    }

    public void unwatch() {
        this.doInScope("UNWATCH", () -> this.connection.unwatch());
    }

    public Long publish(byte[] channel, byte[] message) {
        return this.doInScope("PUBLISH", () -> this.connection.publish(channel, message));
    }

    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.doInScope("SUBSCRIBE", () -> this.connection.subscribe(listener, channels));
    }

    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.doInScope("PSUBSCRIBE", () -> this.connection.pSubscribe(listener, patterns));
    }

    public void select(int dbIndex) {
        this.doInScope("SELECT", () -> this.connection.select(dbIndex));
    }

    public byte[] echo(byte[] message) {
        return this.doInScope("ECHO", () -> this.connection.echo(message));
    }

    public String ping() {
        return this.doInScope("PING", () -> this.connection.ping());
    }

    public void bgWriteAof() {
        this.doInScope("BGWRITEAOF", () -> this.connection.bgWriteAof());
    }

    public void bgReWriteAof() {
        this.doInScope("BGREWRITEAOF", () -> this.connection.bgReWriteAof());
    }

    public void bgSave() {
        this.doInScope("BGSAVE", () -> this.connection.bgSave());
    }

    public Long lastSave() {
        return this.doInScope("LASTSAVE", () -> this.connection.lastSave());
    }

    public void save() {
        this.doInScope("SAVE", () -> this.connection.save());
    }

    public Long dbSize() {
        return this.doInScope("DBSIZE", () -> this.connection.dbSize());
    }

    public void flushDb() {
        this.doInScope("FLUSHDB", () -> this.connection.flushDb());
    }

    public void flushAll() {
        this.doInScope("FLUSHALL", () -> this.connection.flushAll());
    }

    public Properties info() {
        return this.doInScope("INFO", () -> this.connection.info());
    }

    public Properties info(String section) {
        return this.doInScope("INFO", () -> this.connection.info(section));
    }

    public void shutdown() {
        this.doInScope("SHUTDOWN", () -> this.connection.shutdown());
    }

    public void shutdown(RedisServerCommands.ShutdownOption option) {
        this.doInScope("SHUTDOWN", () -> this.connection.shutdown(option));
    }

    public Properties getConfig(String pattern) {
        return this.doInScope("CONFIG GET", () -> this.connection.getConfig(pattern));
    }

    public void setConfig(String param, String value) {
        this.doInScope("CONFIG SET", () -> this.connection.setConfig(param, value));
    }

    public void resetConfigStats() {
        this.doInScope("CONFIG RESETSTAT", () -> this.connection.resetConfigStats());
    }

    public Long time() {
        return this.doInScope("TIME", () -> this.connection.time());
    }

    public void killClient(String host, int port) {
        this.doInScope("CLIENT KILL", () -> this.connection.killClient(host, port));
    }

    public void setClientName(byte[] name) {
        this.doInScope("CLIENT SETNAME", () -> this.connection.setClientName(name));
    }

    public String getClientName() {
        return this.doInScope("CLIENT GETNAME", () -> this.connection.getClientName());
    }

    public List<RedisClientInfo> getClientList() {
        return this.doInScope("CLIENT LIST", () -> this.connection.getClientList());
    }

    public void slaveOf(String host, int port) {
        this.doInScope("SLAVEOF", () -> this.connection.slaveOf(host, port));
    }

    public void slaveOfNoOne() {
        this.doInScope("SLAVEOFNOONE", () -> this.connection.slaveOfNoOne());
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        this.doInScope("MIGRATE", () -> this.connection.migrate(key, target, dbIndex, option));
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        this.doInScope("MIGRATE", () -> this.connection.migrate(key, target, dbIndex, option, timeout));
    }

    public void scriptFlush() {
        this.doInScope("SCRIPT FLUSH", () -> this.connection.scriptFlush());
    }

    public void scriptKill() {
        this.doInScope("SCRIPT KILL", () -> this.connection.scriptKill());
    }

    public String scriptLoad(byte[] script) {
        return this.doInScope("SCRIPT LOAD", () -> this.connection.scriptLoad(script));
    }

    public List<Boolean> scriptExists(String ... scriptShas) {
        return this.doInScope("SCRIPT EXISTS", () -> this.connection.scriptExists(scriptShas));
    }

    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return (T)this.doInScope("EVAL", () -> this.connection.eval(script, returnType, numKeys, keysAndArgs));
    }

    public <T> T evalSha(String scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return (T)this.doInScope("EVALSHA", () -> this.connection.evalSha(scriptSha, returnType, numKeys, keysAndArgs));
    }

    public <T> T evalSha(byte[] scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return (T)this.doInScope("EVALSHA", () -> this.connection.evalSha(scriptSha, returnType, numKeys, keysAndArgs));
    }

    public Long geoAdd(byte[] key, Point point, byte[] member) {
        return this.doInScope("GEOADD", () -> this.connection.geoAdd(key, point, member));
    }

    public Long geoAdd(byte[] key, RedisGeoCommands.GeoLocation<byte[]> location) {
        return this.doInScope("GEOADD", () -> this.connection.geoAdd(key, location));
    }

    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        return this.doInScope("GEOADD", () -> this.connection.geoAdd(key, memberCoordinateMap));
    }

    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        return this.doInScope("GEOADD", () -> this.connection.geoAdd(key, locations));
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        return this.doInScope("GEODIST", () -> this.connection.geoDist(key, member1, member2));
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        return this.doInScope("GEODIST", () -> this.connection.geoDist(key, member1, member2, metric));
    }

    public List<String> geoHash(byte[] key, byte[] ... members) {
        return this.doInScope("GEOHASH", () -> this.connection.geoHash(key, members));
    }

    public List<Point> geoPos(byte[] key, byte[] ... members) {
        return this.doInScope("GEOPOS", () -> this.connection.geoPos(key, members));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        return this.doInScope("GEORADIUS", () -> this.connection.geoRadius(key, within));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.doInScope("GEORADIUS", () -> this.connection.geoRadius(key, within, args));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.doInScope("GEORADIUSBYMEMBER", () -> this.connection.geoRadiusByMember(key, member, radius));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        return this.doInScope("GEORADIUSBYMEMBER", () -> this.connection.geoRadiusByMember(key, member, radius));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.doInScope("GEORADIUSBYMEMBER", () -> this.connection.geoRadiusByMember(key, member, radius, args));
    }

    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.doInScope("GEOREMOVE", () -> this.connection.geoRemove(key, members));
    }

    public Long pfAdd(byte[] key, byte[] ... values) {
        return this.doInScope("PFADD", () -> this.connection.pfAdd(key, values));
    }

    public Long pfCount(byte[] ... keys) {
        return this.doInScope("PFCOUNT", () -> this.connection.pfCount(keys));
    }

    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        this.doInScope("PFMERGE", () -> this.connection.pfMerge(destinationKey, sourceKeys));
    }
}

