/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.spring.connection;

import io.opentracing.Tracer;
import io.opentracing.contrib.redis.spring.connection.TracingReactiveRedisConnection;
import io.opentracing.contrib.redis.spring.connection.TracingRedisClusterConnection;
import io.opentracing.contrib.redis.spring.connection.TracingRedisConnection;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConnection;

public class TracingRedisConnectionFactory
implements RedisConnectionFactory,
ReactiveRedisConnectionFactory {
    private final RedisConnectionFactory delegate;
    private final boolean withActiveSpanOnly;
    private final Tracer tracer;

    public TracingRedisConnectionFactory(RedisConnectionFactory delegate, boolean withActiveSpanOnly, Tracer tracer) {
        this.delegate = delegate;
        this.withActiveSpanOnly = withActiveSpanOnly;
        this.tracer = tracer;
    }

    public RedisConnection getConnection() {
        return new TracingRedisConnection(this.delegate.getConnection(), this.withActiveSpanOnly, this.tracer);
    }

    public RedisClusterConnection getClusterConnection() {
        return new TracingRedisClusterConnection(this.delegate.getClusterConnection(), this.withActiveSpanOnly, this.tracer);
    }

    public boolean getConvertPipelineAndTxResults() {
        return this.delegate.getConvertPipelineAndTxResults();
    }

    public RedisSentinelConnection getSentinelConnection() {
        return this.delegate.getSentinelConnection();
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        return this.delegate.translateExceptionIfPossible(e);
    }

    public ReactiveRedisConnection getReactiveConnection() {
        if (this.delegate instanceof ReactiveRedisConnectionFactory) {
            return new TracingReactiveRedisConnection((ReactiveRedisConnection)this.delegate, this.withActiveSpanOnly, this.tracer);
        }
        return null;
    }

    public ReactiveRedisClusterConnection getReactiveClusterConnection() {
        if (this.delegate instanceof ReactiveRedisConnectionFactory) {
            return ((ReactiveRedisConnectionFactory)this.delegate).getReactiveClusterConnection();
        }
        return null;
    }
}

