/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.async;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.async.DefaultAsyncAutoConfiguration;
import io.opentracing.contrib.spring.cloud.async.instrument.TracedAsyncConfigurer;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;

@Configuration
@ConditionalOnBean(value={AsyncConfigurer.class})
@AutoConfigureBefore(value={DefaultAsyncAutoConfiguration.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.async.enabled"}, havingValue="true", matchIfMissing=true)
public class CustomAsyncConfigurerAutoConfiguration
implements BeanPostProcessor {
    @Autowired
    private Tracer tracer;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AsyncConfigurer) {
            AsyncConfigurer configurer = (AsyncConfigurer)bean;
            return new TracedAsyncConfigurer(this.tracer, configurer);
        }
        return bean;
    }
}

