/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.async;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.async.ExecutorMethodInterceptor;
import io.opentracing.contrib.spring.cloud.async.instrument.TracedThreadPoolTaskExecutor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ReflectionUtils;

class ExecutorBeanPostProcessor
implements BeanPostProcessor {
    private final Tracer tracer;

    ExecutorBeanPostProcessor(Tracer tracer) {
        this.tracer = tracer;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Executor && !(bean instanceof ThreadPoolTaskExecutor)) {
            Method execute = ReflectionUtils.findMethod(bean.getClass(), (String)"execute", (Class[])new Class[]{Runnable.class});
            boolean methodFinal = Modifier.isFinal(execute.getModifiers());
            boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
            boolean cglibProxy = !methodFinal && !classFinal;
            Executor executor = (Executor)bean;
            ProxyFactoryBean factory = new ProxyFactoryBean();
            factory.setProxyTargetClass(cglibProxy);
            factory.addAdvice(new ExecutorMethodInterceptor<Executor>(executor, this.tracer));
            factory.setTarget(bean);
            return factory.getObject();
        }
        if (bean instanceof ThreadPoolTaskExecutor) {
            boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
            boolean cglibProxy = !classFinal;
            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)bean;
            ProxyFactoryBean factory = new ProxyFactoryBean();
            factory.setProxyTargetClass(cglibProxy);
            factory.addAdvice((Advice)new ExecutorMethodInterceptor<ThreadPoolTaskExecutor>(executor, this.tracer){

                @Override
                Executor tracedExecutor(Tracer tracer, ThreadPoolTaskExecutor executor) {
                    return new TracedThreadPoolTaskExecutor(tracer, executor);
                }
            });
            factory.setTarget(bean);
            return factory.getObject();
        }
        return bean;
    }
}

