/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.async.instrument;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedCallable;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class TracedThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private final Tracer tracer;
    private final ThreadPoolTaskExecutor delegate;

    public TracedThreadPoolTaskExecutor(Tracer tracer, ThreadPoolTaskExecutor delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
    }

    public void execute(Runnable task) {
        this.delegate.execute((Runnable)new TracedRunnable(task, this.tracer));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute((Runnable)new TracedRunnable(task, this.tracer), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit((Runnable)new TracedRunnable(task, this.tracer));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit((Callable)new TracedCallable(task, this.tracer));
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.delegate.submitListenable((Runnable)new TracedRunnable(task, this.tracer));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.delegate.submitListenable((Callable)new TracedCallable(task, this.tracer));
    }

    public void afterPropertiesSet() {
        this.delegate.afterPropertiesSet();
        super.afterPropertiesSet();
    }

    public void destroy() {
        this.delegate.destroy();
        super.destroy();
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public ThreadPoolExecutor getThreadPoolExecutor() throws IllegalStateException {
        return this.delegate.getThreadPoolExecutor();
    }
}

