/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.scheduled;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.ExtensionTags;
import io.opentracing.contrib.spring.cloud.scheduled.ScheduledTracingProperties;
import io.opentracing.tag.Tags;
import java.util.regex.Pattern;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class ScheduledAspect {
    static final String COMPONENT_NAME = "scheduled";
    private Tracer tracer;
    private Pattern skipPattern;

    public ScheduledAspect(Tracer tracer, ScheduledTracingProperties scheduledTracingProperties) {
        this.tracer = tracer;
        this.skipPattern = Pattern.compile(scheduledTracingProperties.getSkipPattern());
    }

    @Around(value="execution (@org.springframework.scheduling.annotation.Scheduled  * *.*(..))")
    public Object traceBackgroundThread(ProceedingJoinPoint pjp) throws Throwable {
        if (this.skipPattern.matcher(pjp.getTarget().getClass().getName()).matches()) {
            return pjp.proceed();
        }
        try (Scope scope = this.tracer.buildSpan(pjp.getSignature().getName()).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME).withTag(ExtensionTags.CLASS_TAG.getKey(), pjp.getTarget().getClass().getSimpleName()).withTag(ExtensionTags.METHOD_TAG.getKey(), pjp.getSignature().getName()).startActive(true);){
            Object object = pjp.proceed();
            return object;
        }
    }
}

