/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.async;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedExecutor;
import io.opentracing.contrib.concurrent.TracedExecutorService;
import io.opentracing.contrib.spring.cloud.async.ExecutorMethodInterceptor;
import io.opentracing.contrib.spring.cloud.async.instrument.TracedThreadPoolTaskExecutor;
import io.opentracing.contrib.spring.cloud.async.instrument.TracedThreadPoolTaskScheduler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ReflectionUtils;

class ExecutorBeanPostProcessor
implements BeanPostProcessor {
    private final Tracer tracer;

    ExecutorBeanPostProcessor(Tracer tracer) {
        this.tracer = tracer;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Executor) {
            if (bean instanceof ExecutorService) {
                ExecutorService executorService = (ExecutorService)bean;
                return this.proxify(executorService, TracedExecutorService::new, this.shouldUseCGLibProxy(executorService, ExecutorService.class));
            }
            if (bean instanceof ThreadPoolTaskScheduler) {
                boolean classNotFinal;
                ThreadPoolTaskScheduler threadPoolTaskScheduler = (ThreadPoolTaskScheduler)bean;
                boolean bl = classNotFinal = !Modifier.isFinal(threadPoolTaskScheduler.getClass().getModifiers());
                if (classNotFinal) {
                    return this.proxify(threadPoolTaskScheduler, (e, t) -> new TracedThreadPoolTaskScheduler((Tracer)t, (ThreadPoolTaskScheduler)e), true);
                }
                return bean;
            }
            if (bean instanceof ThreadPoolTaskExecutor) {
                boolean classNotFinal;
                ThreadPoolTaskExecutor threadPoolTaskExecutor = (ThreadPoolTaskExecutor)bean;
                boolean bl = classNotFinal = !Modifier.isFinal(threadPoolTaskExecutor.getClass().getModifiers());
                if (classNotFinal) {
                    return this.proxify(threadPoolTaskExecutor, (e, t) -> new TracedThreadPoolTaskExecutor((Tracer)t, (ThreadPoolTaskExecutor)e), true);
                }
                return bean;
            }
            Executor executor = (Executor)bean;
            return this.proxify(executor, TracedExecutor::new, this.shouldUseCGLibProxy(executor, Executor.class));
        }
        return bean;
    }

    private <T extends Executor> Object proxify(T executor, BiFunction<T, Tracer, T> tracingExecutorProvider, boolean useCglib) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(useCglib);
        factory.addAdvice(new ExecutorMethodInterceptor<T>(executor, tracingExecutorProvider, this.tracer));
        factory.setTarget(executor);
        return factory.getObject();
    }

    private boolean shouldUseCGLibProxy(Executor executor, Class<? extends Executor> iface) {
        boolean anyMethodFinal = Stream.of(ReflectionUtils.getAllDeclaredMethods(iface)).map(method -> ReflectionUtils.findMethod(executor.getClass(), (String)method.getName(), (Class[])method.getParameterTypes())).map(Optional::ofNullable).map(method -> (Method)method.orElseThrow(NoSuchMethodError::new)).map(Method::getModifiers).anyMatch(Modifier::isFinal);
        boolean classFinal = Modifier.isFinal(executor.getClass().getModifiers());
        return !anyMethodFinal && !classFinal;
    }
}

