/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.jdbc;

import io.opentracing.contrib.spring.cloud.jdbc.JdbcAspect;
import io.opentracing.contrib.spring.cloud.jdbc.JdbcTracingProperties;
import io.opentracing.contrib.spring.tracer.configuration.TracerRegisterAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={TracerRegisterAutoConfiguration.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.jdbc.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={JdbcTracingProperties.class})
public class JdbcAutoConfiguration {
    @Bean
    public JdbcAspect jdbcAspect(JdbcTracingProperties jdbcTracingProperties) {
        return new JdbcAspect(jdbcTracingProperties.isWithActiveSpanOnly(), jdbcTracingProperties.getIgnoreStatements());
    }
}

