/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.mongo;

import com.mongodb.MongoClient;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.mongo.TracingMongoClientPostProcessor;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={TracerAutoConfiguration.class, MongoAutoConfiguration.class})
@ConditionalOnBean(value={Tracer.class, MongoClient.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.mongo.enabled"}, havingValue="true", matchIfMissing=true)
public class MongoTracingAutoConfiguration {
    private final Tracer tracer;

    public MongoTracingAutoConfiguration(Tracer tracer) {
        this.tracer = tracer;
    }

    @Bean
    TracingMongoClientPostProcessor tracingMongoClientPostProcessor() {
        return new TracingMongoClientPostProcessor(this.tracer);
    }
}

