/*
 * Decompiled with CFR 0.152.
 */
package io.prestodb.tempto.runner;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import io.prestodb.tempto.dns.TemptoNameServiceDescriptor;
import io.prestodb.tempto.internal.listeners.TestNameGroupNameMethodSelector;
import io.prestodb.tempto.runner.TemptoRunnerCommandLineParser;
import io.prestodb.tempto.runner.TemptoRunnerOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TemptoRunner {
    private static final Logger LOG;
    private static final int METHOD_SELECTOR_PRIORITY = 20;
    private static final String METHOD_SELECTOR_CLASS_NAME;
    private final TemptoRunnerCommandLineParser parser;
    private final TemptoRunnerOptions options;

    public static void runTempto(TemptoRunnerCommandLineParser parser, String[] args) {
        TemptoRunnerOptions options = parser.parseCommandLine(args);
        try {
            TemptoRunner.runTempto(parser, options);
        }
        catch (TemptoRunnerCommandLineParser.ParsingException e) {
            System.err.println("Could not parse command line. " + e.getMessage());
            System.err.println();
            parser.printHelpMessage();
            System.exit(1);
        }
    }

    public static void runTempto(TemptoRunnerCommandLineParser parser, TemptoRunnerOptions options) {
        new TemptoRunner(parser, options).run();
    }

    private TemptoRunner(TemptoRunnerCommandLineParser parser, TemptoRunnerOptions options) {
        this.parser = parser;
        this.options = options;
    }

    private void run() {
        LOG.debug("running tempto with options: {}", (Object)this.options);
        if (this.options.isHelpRequested()) {
            this.parser.printHelpMessage();
            return;
        }
        XmlSuite testSuite = this.getXmlSuite();
        testSuite.setThreadCount(this.options.getThreadCount());
        this.setupTestsConfiguration();
        System.setProperty("tempto.convention.tests.dir", this.options.getConventionTestsDirectory());
        TestNG testNG = new TestNG();
        testNG.setXmlSuites(Collections.singletonList(testSuite));
        testNG.setOutputDirectory(this.options.getReportDir());
        this.setupTestsFiltering(testNG);
        this.options.getConventionResultsDumpPath().ifPresent(path -> System.setProperty("tempto.convention.tests.results.dump", path));
        testNG.run();
        if (testNG.hasFailure()) {
            System.exit(1);
        }
    }

    private void setupTestsConfiguration() {
        System.setProperty("tempto.configurations", this.options.getConfigFiles());
    }

    private void setupTestsFiltering(TestNG testNG) {
        if (!this.options.getTestGroups().isEmpty()) {
            System.setProperty("io.prestodb.tempto.groups", Joiner.on((char)',').join(this.options.getTestGroups()));
        }
        if (!this.options.getExcludeGroups().isEmpty()) {
            System.setProperty("io.prestodb.tempto.exclude_groups", Joiner.on((char)',').join(this.options.getExcludeGroups()));
        }
        if (!this.options.getTests().isEmpty()) {
            System.setProperty("io.prestodb.tempto.tests", Joiner.on((char)',').join(this.options.getTests()));
        }
        testNG.addMethodSelector(METHOD_SELECTOR_CLASS_NAME, 20);
    }

    private XmlSuite getXmlSuite() {
        XmlSuite testSuite = new XmlSuite();
        testSuite.setName("tempto-tests");
        testSuite.setFileName("tempto-tests");
        XmlTest test = new XmlTest(testSuite);
        test.setName("all");
        XmlPackage testPackage = new XmlPackage(this.options.getTestsPackage());
        ArrayList testPackages = Lists.newArrayList((Object[])new XmlPackage[]{testPackage});
        test.setPackages((List)testPackages);
        XmlClass conventionBasedTestsClass = new XmlClass("io.prestodb.tempto.internal.convention.ConventionBasedTestFactory");
        ArrayList classes = Lists.newArrayList((Object[])new XmlClass[]{conventionBasedTestsClass});
        test.setClasses((List)classes);
        test.setParallel(XmlSuite.ParallelMode.METHODS);
        return testSuite;
    }

    static {
        TemptoNameServiceDescriptor.enableHostMapping();
        LOG = LoggerFactory.getLogger(TemptoRunner.class);
        METHOD_SELECTOR_CLASS_NAME = TestNameGroupNameMethodSelector.class.getName();
    }
}

