/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.config.discovery;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.ClientConfig;
import io.searchbox.cluster.NodesInfo;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeChecker
extends AbstractScheduledService {
    private static final Logger logger = LoggerFactory.getLogger(NodeChecker.class);
    private final NodesInfo action = new NodesInfo.Builder().build();
    JestClient client;
    ClientConfig clientConfig;

    public NodeChecker(ClientConfig clientConfig, JestClient jestClient) {
        this.client = jestClient;
        this.clientConfig = clientConfig;
    }

    protected void runOneIteration() throws Exception {
        JestResult result = null;
        try {
            result = this.client.execute(this.action);
        }
        catch (Exception e) {
            logger.error("Error executing NodesInfo!", (Throwable)e);
        }
        if (result != null) {
            LinkedHashSet<String> httpHosts = new LinkedHashSet<String>();
            JsonObject jsonMap = result.getJsonObject();
            JsonObject nodes = (JsonObject)jsonMap.get("nodes");
            if (nodes != null) {
                for (Map.Entry entry : nodes.entrySet()) {
                    JsonObject host = (JsonObject)entry.getValue();
                    JsonElement addressElement = host.get("http_address");
                    if (null == addressElement) continue;
                    String http_address = addressElement.getAsString();
                    String cleanHttpAddress = "http://" + http_address.substring(6, http_address.length() - 1);
                    httpHosts.add(cleanHttpAddress);
                }
            }
            logger.info("Discovered Http Hosts: {}", httpHosts);
            this.client.setServers(httpHosts);
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)this.clientConfig.getDiscoveryFrequency(), (TimeUnit)this.clientConfig.getDiscoveryFrequencyTimeUnit());
    }
}

