/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.facet;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.facet.Facet;
import java.util.ArrayList;
import java.util.List;

public class TermsFacet
extends Facet {
    public static final String TYPE = "terms";
    private Long missing;
    private Long total;
    private Long other;
    private List<Term> terms;

    public TermsFacet(String name, JsonObject termFacet) {
        this.name = name;
        this.missing = termFacet.get("missing").getAsLong();
        this.total = termFacet.get("total").getAsLong();
        this.other = termFacet.get("other").getAsLong();
        this.terms = new ArrayList<Term>();
        for (JsonElement termv : termFacet.get(TYPE).getAsJsonArray()) {
            JsonObject term = (JsonObject)termv;
            Term entry = new Term(term.get("term").getAsString(), term.get("count").getAsInt());
            this.terms.add(entry);
        }
    }

    public Long getMissing() {
        return this.missing;
    }

    public Long getTotal() {
        return this.total;
    }

    public Long getOther() {
        return this.other;
    }

    public List<Term> terms() {
        return this.terms;
    }

    public class Term {
        private String name;
        private Integer count;

        public Term(String name, Integer count) {
            this.name = name;
            this.count = count;
        }

        public String getName() {
            return this.name;
        }

        public Integer getCount() {
            return this.count;
        }
    }
}

