/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.zk;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.StringUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationChangeType;
import io.seata.config.ConfigurationFactory;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfiguration.class);
    private static final String CONFIG_TYPE = "zk";
    private static final String ZK_PATH_SPLIT_CHAR = "/";
    private static final String ROOT_PATH = "/seata";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String SESSION_TIMEOUT_KEY = "session.timeout";
    private static final String CONNECT_TIMEOUT_KEY = "connect.timeout";
    private static final String AUTH_USERNAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final int THREAD_POOL_NUM = 1;
    private static final int DEFAULT_SESSION_TIMEOUT = 6000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final String FILE_CONFIG_KEY_PREFIX = "config.zk.";
    private static final ExecutorService CONFIG_EXECUTOR = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("ZKConfigThread", 1));
    private static volatile ZkClient zkClient;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ConcurrentMap<String, ConcurrentMap<ConfigurationChangeListener, ZKListener>> configListenersMap = new ConcurrentHashMap<String, ConcurrentMap<ConfigurationChangeListener, ZKListener>>(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZookeeperConfiguration() {
        if (zkClient != null) return;
        Class<ZookeeperConfiguration> clazz = ZookeeperConfiguration.class;
        synchronized (ZookeeperConfiguration.class) {
            if (null == zkClient) {
                zkClient = new ZkClient(FILE_CONFIG.getConfig("config.zk.serverAddr"), FILE_CONFIG.getInt("config.zk.session.timeout", 6000), FILE_CONFIG.getInt("config.zk.connect.timeout", 2000));
                String username = FILE_CONFIG.getConfig("config.zk.username");
                String password = FILE_CONFIG.getConfig("config.zk.password");
                if (!StringUtils.isBlank((String)username) && !StringUtils.isBlank((String)password)) {
                    StringBuilder auth = new StringBuilder(username).append(":").append(password);
                    zkClient.addAuthInfo("digest", auth.toString().getBytes());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (zkClient.exists(ROOT_PATH)) return;
            zkClient.createPersistent(ROOT_PATH, true);
            return;
        }
    }

    public String getTypeName() {
        return CONFIG_TYPE;
    }

    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSysPro(dataId);
        if (value != null) {
            return value;
        }
        FutureTask<String> future = new FutureTask<String>(() -> {
            String path = "/seata/" + dataId;
            String value1 = (String)zkClient.readData(path);
            return StringUtils.isNullOrEmpty((String)value1) ? defaultValue : value1;
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.error("getConfig {} is error or timeout,return defaultValue {}", (Object)dataId, (Object)defaultValue);
            return defaultValue;
        }
    }

    public boolean putConfig(String dataId, String content, long timeoutMills) {
        FutureTask<Boolean> future = new FutureTask<Boolean>(() -> {
            String path = "/seata/" + dataId;
            if (!zkClient.exists(path)) {
                zkClient.create(path, (Object)content, CreateMode.PERSISTENT);
            } else {
                zkClient.writeData(path, (Object)content);
            }
            return true;
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("putConfig {} : {} is error or timeout", (Object)dataId, (Object)content);
            return false;
        }
    }

    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    public boolean removeConfig(String dataId, long timeoutMills) {
        FutureTask<Boolean> future = new FutureTask<Boolean>(() -> {
            String path = "/seata/" + dataId;
            return zkClient.delete(path);
        });
        CONFIG_EXECUTOR.execute(future);
        try {
            return future.get(timeoutMills, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("removeConfig {} is error or timeout", (Object)dataId);
            return false;
        }
    }

    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (null == dataId || null == listener) {
            return;
        }
        String path = "/seata/" + dataId;
        if (zkClient.exists(path)) {
            this.configListenersMap.putIfAbsent(dataId, new ConcurrentHashMap());
            ZKListener zkListener = new ZKListener(path, listener);
            ((ConcurrentMap)this.configListenersMap.get(dataId)).put(listener, zkListener);
            zkClient.subscribeDataChanges(path, (IZkDataListener)zkListener);
        }
    }

    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        Set<ConfigurationChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (configChangeListeners == null || listener == null) {
            return;
        }
        String path = "/seata/" + dataId;
        if (zkClient.exists(path)) {
            for (ConfigurationChangeListener entry : configChangeListeners) {
                if (!listener.equals(entry)) continue;
                ZKListener zkListener = null;
                if (this.configListenersMap.containsKey(dataId)) {
                    zkListener = (ZKListener)((ConcurrentMap)this.configListenersMap.get(dataId)).get(listener);
                    ((ConcurrentMap)this.configListenersMap.get(dataId)).remove(entry);
                }
                if (null == zkListener) break;
                zkClient.unsubscribeDataChanges(path, zkListener);
                break;
            }
        }
    }

    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        if (this.configListenersMap.containsKey(dataId)) {
            return ((ConcurrentMap)this.configListenersMap.get(dataId)).keySet();
        }
        return null;
    }

    public static class ZKListener
    implements IZkDataListener {
        private String path;
        private ConfigurationChangeListener listener;

        public ZKListener(String path, ConfigurationChangeListener listener) {
            this.path = path;
            this.listener = listener;
        }

        public void handleDataChange(String s, Object o) {
            ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(s).setNewValue(o.toString()).setChangeType(ConfigurationChangeType.MODIFY);
            this.listener.onProcessEvent(event);
        }

        public void handleDataDeleted(String s) {
            ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(s).setChangeType(ConfigurationChangeType.DELETE);
            this.listener.onProcessEvent(event);
        }
    }
}

