/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.orchestration.api;

import io.shardingsphere.api.config.rule.MasterSlaveRuleConfiguration;
import io.shardingsphere.orchestration.config.OrchestrationConfiguration;
import io.shardingsphere.shardingjdbc.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingsphere.shardingjdbc.orchestration.internal.datasource.OrchestrationMasterSlaveDataSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class OrchestrationMasterSlaveDataSourceFactory {
    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, Map<String, Object> configMap, Properties props, OrchestrationConfiguration orchestrationConfig) throws SQLException {
        if (null == masterSlaveRuleConfig || null == masterSlaveRuleConfig.getMasterDataSourceName()) {
            return OrchestrationMasterSlaveDataSourceFactory.createDataSource(orchestrationConfig);
        }
        MasterSlaveDataSource masterSlaveDataSource = new MasterSlaveDataSource(dataSourceMap, masterSlaveRuleConfig, configMap, props);
        return new OrchestrationMasterSlaveDataSource(masterSlaveDataSource, orchestrationConfig);
    }

    public static DataSource createDataSource(OrchestrationConfiguration orchestrationConfig) throws SQLException {
        return new OrchestrationMasterSlaveDataSource(orchestrationConfig);
    }

    private OrchestrationMasterSlaveDataSourceFactory() {
    }
}

