/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.context;

import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.auth.context.IdentityContextBuilder;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class HttpIdentityContextBuilder
implements IdentityContextBuilder<HttpServletRequest> {
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_FOR_SPLIT_SYMBOL = ",";
    private final AuthConfigs authConfigs;

    public HttpIdentityContextBuilder(AuthConfigs authConfigs) {
        this.authConfigs = authConfigs;
    }

    @Override
    public IdentityContext build(HttpServletRequest request) {
        IdentityContext result = new IdentityContext();
        this.getRemoteIp(request, result);
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(this.authConfigs.getNacosAuthSystemType());
        if (!authPluginService.isPresent()) {
            return result;
        }
        TreeMap<String, String> identityNames = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String each : ((AuthPluginService)authPluginService.get()).identityNames()) {
            identityNames.put(each, each);
        }
        this.getIdentityFromHeader(request, result, identityNames);
        this.getIdentityFromParameter(request, result, identityNames);
        return result;
    }

    private void getIdentityFromHeader(HttpServletRequest request, IdentityContext result, Map<String, String> identityNames) {
        Enumeration headerEnu = request.getHeaderNames();
        while (headerEnu.hasMoreElements()) {
            String paraName = (String)headerEnu.nextElement();
            if (!identityNames.containsKey(paraName)) continue;
            result.setParameter(identityNames.get(paraName), (Object)request.getHeader(paraName));
        }
    }

    private void getIdentityFromParameter(HttpServletRequest request, IdentityContext result, Map<String, String> identityNames) {
        Enumeration paramEnu = request.getParameterNames();
        while (paramEnu.hasMoreElements()) {
            String paraName = (String)paramEnu.nextElement();
            if (!identityNames.containsKey(paraName)) continue;
            result.setParameter(identityNames.get(paraName), (Object)request.getParameter(paraName));
        }
    }

    private void getRemoteIp(HttpServletRequest request, IdentityContext result) {
        String remoteIp = "";
        String xForwardedFor = request.getHeader(X_FORWARDED_FOR);
        if (!StringUtils.isBlank((CharSequence)xForwardedFor)) {
            remoteIp = xForwardedFor.split(X_FORWARDED_FOR_SPLIT_SYMBOL)[0].trim();
        }
        if (StringUtils.isBlank((CharSequence)remoteIp)) {
            String nginxHeader = request.getHeader("X-Real-IP");
            remoteIp = StringUtils.isBlank((CharSequence)nginxHeader) ? request.getRemoteAddr() : nginxHeader;
        }
        result.setParameter("remote_ip", (Object)remoteIp);
    }
}

