/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.MultiMap;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.impl.PathAdjuster;
import org.vertx.java.core.http.HttpHeaders;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.http.impl.AssembledFullHttpResponse;
import org.vertx.java.core.http.impl.AssembledHttpResponse;
import org.vertx.java.core.http.impl.AssembledLastHttpContent;
import org.vertx.java.core.http.impl.HttpHeadersAdapter;
import org.vertx.java.core.http.impl.MimeMapping;
import org.vertx.java.core.http.impl.ServerConnection;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;

public class DefaultHttpServerResponse
implements HttpServerResponse {
    private static final Buffer NOT_FOUND = new Buffer("<html><body>Resource not found</body><html>");
    private static final Buffer FORBIDDEN = new Buffer("<html><body>Forbidden</body><html>");
    private final VertxInternal vertx;
    private final ServerConnection conn;
    private final HttpResponse response;
    private final HttpVersion version;
    private final boolean keepAlive;
    private boolean headWritten;
    private boolean written;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private boolean chunked;
    private boolean closed;
    private ChannelFuture channelFuture;
    private MultiMap headers;
    private LastHttpContent trailing;
    private MultiMap trailers;
    private String statusMessage;

    DefaultHttpServerResponse(VertxInternal vertx, ServerConnection conn, HttpRequest request) {
        this.vertx = vertx;
        this.conn = conn;
        this.version = request.getProtocolVersion();
        this.response = new DefaultHttpResponse(this.version, HttpResponseStatus.OK, false);
        this.keepAlive = this.version == HttpVersion.HTTP_1_1 || this.version == HttpVersion.HTTP_1_0 && request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE, true);
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HttpHeadersAdapter(this.response.headers());
        }
        return this.headers;
    }

    @Override
    public MultiMap trailers() {
        if (this.trailers == null) {
            if (this.trailing == null) {
                this.trailing = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, false);
            }
            this.trailers = new HttpHeadersAdapter(this.trailing.trailingHeaders());
        }
        return this.trailers;
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatus().code();
    }

    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        HttpResponseStatus status = this.statusMessage != null ? new HttpResponseStatus(statusCode, this.statusMessage) : HttpResponseStatus.valueOf((int)statusCode);
        this.response.setStatus(status);
        return this;
    }

    @Override
    public String getStatusMessage() {
        return this.response.getStatus().reasonPhrase();
    }

    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        this.response.setStatus(new HttpResponseStatus(this.response.getStatus().code(), statusMessage));
        return this;
    }

    @Override
    public DefaultHttpServerResponse setChunked(boolean chunked) {
        this.checkWritten();
        if (this.version != HttpVersion.HTTP_1_0) {
            this.chunked = chunked;
        }
        return this;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public DefaultHttpServerResponse putHeader(String key, String value) {
        this.checkWritten();
        this.headers().set(key, value);
        return this;
    }

    @Override
    public DefaultHttpServerResponse putHeader(String key, Iterable<String> values) {
        this.checkWritten();
        this.headers().set(key, values);
        return this;
    }

    @Override
    public DefaultHttpServerResponse putTrailer(String key, String value) {
        this.checkWritten();
        this.trailers().set(key, value);
        return this;
    }

    @Override
    public DefaultHttpServerResponse putTrailer(String key, Iterable<String> values) {
        this.checkWritten();
        this.trailers().set(key, values);
        return this;
    }

    @Override
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.checkWritten();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.checkWritten();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        this.checkWritten();
        this.trailers().set(name, value);
        return this;
    }

    @Override
    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        this.checkWritten();
        this.trailers().set(name, value);
        return this;
    }

    @Override
    public HttpServerResponse setWriteQueueMaxSize(int size) {
        this.checkWritten();
        this.conn.doSetWriteQueueMaxSize(size);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        this.checkWritten();
        return this.conn.doWriteQueueFull();
    }

    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        this.checkWritten();
        this.drainHandler = handler;
        this.conn.handleInterestedOpsChanged();
        return this;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.checkWritten();
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        this.checkWritten();
        this.closeHandler = handler;
        return this;
    }

    @Override
    public DefaultHttpServerResponse write(Buffer chunk) {
        ByteBuf buf = chunk.getByteBuf();
        return this.write(buf, null);
    }

    @Override
    public DefaultHttpServerResponse write(String chunk, String enc) {
        return this.write(new Buffer(chunk, enc).getByteBuf(), null);
    }

    @Override
    public DefaultHttpServerResponse write(String chunk) {
        return this.write(new Buffer(chunk).getByteBuf(), null);
    }

    @Override
    public void end(String chunk) {
        this.end(new Buffer(chunk));
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(new Buffer(chunk, enc));
    }

    @Override
    public void end(Buffer chunk) {
        if (!this.chunked && !this.contentLengthSet()) {
            this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.length()));
        }
        ByteBuf buf = chunk.getByteBuf();
        this.end0(buf);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.headWritten) {
                this.closeConnAfterWrite();
            } else {
                this.conn.close();
            }
            this.closed = true;
        }
    }

    @Override
    public void end() {
        this.end0(Unpooled.EMPTY_BUFFER);
    }

    private void end0(ByteBuf data) {
        this.checkWritten();
        if (!this.headWritten) {
            this.prepareHeaders();
            AssembledFullHttpResponse resp = this.trailing != null ? new AssembledFullHttpResponse(this.response, data, this.trailing.trailingHeaders(), this.trailing.getDecoderResult()) : new AssembledFullHttpResponse(this.response, data);
            this.channelFuture = this.conn.write(resp);
            this.headWritten = true;
        } else if (!data.isReadable()) {
            this.channelFuture = this.trailing == null ? this.conn.write(LastHttpContent.EMPTY_LAST_CONTENT) : this.conn.write(this.trailing);
        } else {
            Object content = this.trailing != null ? new AssembledLastHttpContent(data, this.trailing.trailingHeaders(), this.trailing.getDecoderResult()) : new DefaultLastHttpContent(data, false);
            this.channelFuture = this.conn.write(content);
        }
        if (!this.keepAlive) {
            this.closeConnAfterWrite();
        }
        this.written = true;
        this.conn.responseComplete();
    }

    @Override
    public DefaultHttpServerResponse sendFile(String filename) {
        return this.sendFile(filename, (String)null);
    }

    @Override
    public DefaultHttpServerResponse sendFile(String filename, String notFoundResource) {
        this.doSendFile(filename, notFoundResource, null);
        return this;
    }

    @Override
    public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        return this.sendFile(filename, null, resultHandler);
    }

    @Override
    public HttpServerResponse sendFile(String filename, String notFoundFile, Handler<AsyncResult<Void>> resultHandler) {
        this.doSendFile(filename, notFoundFile, resultHandler);
        return this;
    }

    private void doSendFile(String filename, String notFoundResource, final Handler<AsyncResult<Void>> resultHandler) {
        if (this.headWritten) {
            throw new IllegalStateException("Head already written");
        }
        this.checkWritten();
        File file = new File(PathAdjuster.adjust(this.vertx, filename));
        if (!file.exists()) {
            if (notFoundResource != null) {
                this.setStatusCode(HttpResponseStatus.NOT_FOUND.code());
                this.sendFile(notFoundResource, null, resultHandler);
            } else {
                this.sendNotFound();
            }
        } else if (file.isDirectory()) {
            this.sendForbidden();
        } else {
            String ext;
            String contentType;
            int li;
            if (!this.contentLengthSet()) {
                this.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(file.length()));
            }
            if (!this.contentTypeSet() && (li = filename.lastIndexOf(46)) != -1 && li != filename.length() - 1 && (contentType = MimeMapping.getMimeTypeForExtension(ext = filename.substring(li + 1, filename.length()))) != null) {
                this.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
            }
            this.prepareHeaders();
            this.conn.queueForWrite(this.response);
            this.conn.sendFile(file);
            this.channelFuture = this.conn.write(LastHttpContent.EMPTY_LAST_CONTENT);
            this.written = true;
            this.headWritten = true;
            if (resultHandler != null) {
                this.channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        final DefaultFutureResult<Object> res = future.isSuccess() ? new DefaultFutureResult<Void>((Void)null) : new DefaultFutureResult<Throwable>(future.cause());
                        DefaultHttpServerResponse.this.vertx.runOnContext(new Handler<Void>(){

                            @Override
                            public void handle(Void v) {
                                resultHandler.handle(res);
                            }
                        });
                    }
                });
            }
            if (!this.keepAlive) {
                this.closeConnAfterWrite();
            }
            this.conn.responseComplete();
        }
    }

    private boolean contentLengthSet() {
        if (this.headers == null) {
            return false;
        }
        return this.response.headers().contains(HttpHeaders.CONTENT_LENGTH);
    }

    private boolean contentTypeSet() {
        if (this.headers == null) {
            return false;
        }
        return this.response.headers().contains(HttpHeaders.CONTENT_TYPE);
    }

    private void closeConnAfterWrite() {
        if (this.channelFuture != null) {
            this.channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    DefaultHttpServerResponse.this.conn.close();
                }
            });
        }
    }

    private void sendForbidden() {
        this.setStatusCode(HttpResponseStatus.FORBIDDEN.code());
        this.putHeader(HttpHeaders.CONTENT_TYPE, HttpHeaders.TEXT_HTML);
        this.end(FORBIDDEN);
    }

    private void sendNotFound() {
        this.setStatusCode(HttpResponseStatus.NOT_FOUND.code());
        this.putHeader(HttpHeaders.CONTENT_TYPE, HttpHeaders.TEXT_HTML);
        this.end(NOT_FOUND);
    }

    void handleDrained() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        }
    }

    void handleClosed() {
        if (this.closeHandler != null) {
            this.closeHandler.handle(null);
        }
    }

    private void checkWritten() {
        if (this.written) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    private void prepareHeaders() {
        if (this.version == HttpVersion.HTTP_1_0 && this.keepAlive) {
            this.response.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        }
        if (this.chunked) {
            this.response.headers().set(HttpHeaders.TRANSFER_ENCODING, (Object)HttpHeaders.CHUNKED);
        } else if (this.version != HttpVersion.HTTP_1_0 && !this.contentLengthSet()) {
            this.response.headers().set(HttpHeaders.CONTENT_LENGTH, (Object)"0");
        }
    }

    private DefaultHttpServerResponse write(ByteBuf chunk, Handler<AsyncResult<Void>> doneHandler) {
        this.checkWritten();
        if (!(this.headWritten || this.version == HttpVersion.HTTP_1_0 || this.chunked || this.contentLengthSet())) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        if (!this.headWritten) {
            this.prepareHeaders();
            this.channelFuture = this.conn.write(new AssembledHttpResponse(this.response, chunk));
            this.headWritten = true;
        } else {
            this.channelFuture = this.conn.write(new DefaultHttpContent(chunk));
        }
        this.conn.addFuture(doneHandler, this.channelFuture);
        return this;
    }
}

