/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.impl;

import io.grpc.stub.StreamObserver;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.grpc.GrpcReadStream;

public class GrpcReadStreamImpl<T>
implements GrpcReadStream<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcReadStreamImpl.class);
    private Handler<T> streamHandler;
    private Handler<Throwable> errorHandler;
    private Handler<Void> endHandler;
    private StreamObserver<T> observer;

    public GrpcReadStreamImpl(StreamObserver<T> observer) {
        this.observer = observer;
    }

    public GrpcReadStreamImpl() {
    }

    @Override
    public GrpcReadStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.errorHandler = handler;
        return this;
    }

    @Override
    public GrpcReadStream<T> handler(Handler<T> handler) {
        this.streamHandler = handler;
        return this;
    }

    @Override
    public GrpcReadStream<T> pause() {
        return this;
    }

    @Override
    public GrpcReadStream<T> resume() {
        return this;
    }

    @Override
    public GrpcReadStream<T> endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public StreamObserver<T> readObserver() {
        if (this.observer == null) {
            this.observer = new StreamObserver<T>(){

                public void onNext(T value) {
                    if (GrpcReadStreamImpl.this.streamHandler != null) {
                        GrpcReadStreamImpl.this.streamHandler.handle(value);
                    }
                }

                public void onError(Throwable t) {
                    if (GrpcReadStreamImpl.this.errorHandler != null) {
                        GrpcReadStreamImpl.this.errorHandler.handle((Object)t);
                    } else {
                        LOG.error((Object)t.getMessage(), t);
                    }
                }

                public void onCompleted() {
                    if (GrpcReadStreamImpl.this.endHandler != null) {
                        GrpcReadStreamImpl.this.endHandler.handle(null);
                    }
                }
            };
        }
        return this.observer;
    }

    @Override
    public GrpcReadStream<T> setReadObserver(StreamObserver<T> observer) {
        this.observer = observer;
        return this;
    }
}

