/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.ruby;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.lang.ruby.ContainerHolder;
import io.vertx.lang.ruby.Deployment;
import io.vertx.lang.ruby.JRubyVerticleFactory;

public class JRubyVerticle
implements Verticle {
    private final JRubyVerticleFactory factory;
    private final ContainerHolder holder;
    private final ClassLoader classLoader;
    private final String verticleName;
    private Vertx vertx;
    private Context context;
    private Deployment instance;

    public JRubyVerticle(JRubyVerticleFactory factory, ContainerHolder holder, ClassLoader classLoader, String verticleName) {
        this.factory = factory;
        this.holder = holder;
        this.classLoader = classLoader;
        this.verticleName = verticleName;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void init(Vertx vertx, Context context) {
        this.vertx = vertx;
        this.context = context;
    }

    public void start(Future<Void> startFuture) throws Exception {
        String gemPath = this.context.config().getString("GEM_PATH");
        this.instance = gemPath != null && !gemPath.trim().isEmpty() ? this.holder.create(gemPath, this.vertx, this.classLoader, startFuture) : this.holder.create(null, this.vertx, this.classLoader, startFuture);
    }

    public void stop(Future<Void> stopFuture) throws Exception {
        if (this.instance != null) {
            this.holder.undeploy(this.instance, stopFuture);
        } else {
            stopFuture.complete();
        }
    }
}

