/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.impl.VertxNetClientMetrics;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Gauges;
import io.vertx.micrometer.impl.meters.Summaries;
import io.vertx.micrometer.impl.meters.Timers;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

class VertxHttpClientMetrics
extends VertxNetClientMetrics {
    private final Timers queueDelay;
    private final Gauges<LongAdder> queueSize;
    private final Gauges<LongAdder> requests;
    private final Counters requestCount;
    private final Summaries requestBytes;
    private final Timers responseTime;
    private final Counters responseCount;
    private final Summaries responseBytes;
    private final Gauges<LongAdder> wsConnections;
    private final Function<HttpRequest, Iterable<Tag>> customTagsProvider;

    VertxHttpClientMetrics(MeterRegistry registry, MetricsNaming names, Function<HttpRequest, Iterable<Tag>> customTagsProvider, ConcurrentMap<Meter.Id, Object> gaugesTable) {
        super(registry, MetricsDomain.HTTP_CLIENT, names, gaugesTable);
        this.customTagsProvider = customTagsProvider;
        this.queueDelay = this.timers(names.getHttpQueueTime(), "Time spent in queue before being processed", Label.LOCAL, Label.REMOTE);
        this.queueSize = this.longGauges(names.getHttpQueuePending(), "Number of pending elements in queue", Label.LOCAL, Label.REMOTE);
        this.requests = this.longGauges(names.getHttpActiveRequests(), "Number of requests waiting for a response", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
        this.requestCount = this.counters(names.getHttpRequestsCount(), "Number of requests sent", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
        this.requestBytes = this.summaries(names.getHttpRequestBytes(), "Size of requests in bytes", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD);
        this.responseTime = this.timers(names.getHttpResponseTime(), "Response time", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
        this.responseCount = this.counters(names.getHttpResponsesCount(), "Response count with codes", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
        this.responseBytes = this.summaries(names.getHttpResponseBytes(), "Size of responses in bytes", Label.LOCAL, Label.REMOTE, Label.HTTP_PATH, Label.HTTP_METHOD, Label.HTTP_CODE);
        this.wsConnections = this.longGauges(names.getHttpActiveWsConnections(), "Number of websockets currently opened", Label.LOCAL, Label.REMOTE);
    }

    HttpClientMetrics forAddress(String localAddress) {
        return new Instance(localAddress);
    }

    public static class Handler {
        private final String address;
        private final String path;
        private final String method;
        private Timers.EventTiming timer;
        HttpResponse response;
        private Iterable<Tag> customTags;
        private boolean responseEnded;
        private boolean requestEnded;
        private boolean reset;

        Handler(String address, String path, String method) {
            this.address = address;
            this.path = path;
            this.method = method;
        }

        void requestReset() {
            this.reset = true;
        }

        boolean requestEnded() {
            this.requestEnded = true;
            return !this.reset && this.responseEnded;
        }

        boolean responseEnded() {
            this.responseEnded = true;
            return !this.reset && this.requestEnded;
        }
    }

    class Instance
    extends VertxNetClientMetrics.Instance
    implements HttpClientMetrics<Handler, String, String, Timers.EventTiming> {
        Instance(String localAddress) {
            super(localAddress);
        }

        public ClientMetrics<Handler, Timers.EventTiming, HttpRequest, HttpResponse> createEndpointMetrics(SocketAddress remoteAddress, int maxPoolSize) {
            final String remote = remoteAddress.toString();
            return new ClientMetrics<Handler, Timers.EventTiming, HttpRequest, HttpResponse>(){

                public Timers.EventTiming enqueueRequest() {
                    ((LongAdder)VertxHttpClientMetrics.this.queueSize.get(Instance.this.local, remote)).increment();
                    return VertxHttpClientMetrics.this.queueDelay.start();
                }

                public void dequeueRequest(Timers.EventTiming taskMetric) {
                    ((LongAdder)VertxHttpClientMetrics.this.queueSize.get(Instance.this.local, remote)).decrement();
                    taskMetric.end(Instance.this.local, remote);
                }

                public Handler requestBegin(String uri, HttpRequest request) {
                    Handler handler = new Handler(remote, request.uri(), request.method().name());
                    if (VertxHttpClientMetrics.this.customTagsProvider != null) {
                        handler.customTags = (Iterable)VertxHttpClientMetrics.this.customTagsProvider.apply(request);
                    }
                    ((LongAdder)VertxHttpClientMetrics.this.requests.get(handler.customTags, Instance.this.local, remote, handler.path, handler.method)).increment();
                    VertxHttpClientMetrics.this.requestCount.get(handler.customTags, Instance.this.local, remote, handler.path, handler.method).increment();
                    handler.timer = VertxHttpClientMetrics.this.responseTime.start();
                    return handler;
                }

                public void requestEnd(Handler handler, long bytesWritten) {
                    VertxHttpClientMetrics.this.requestBytes.get(handler.customTags, Instance.this.local, handler.address, handler.path, handler.method).record((double)bytesWritten);
                    if (handler.requestEnded()) {
                        ((LongAdder)VertxHttpClientMetrics.this.requests.get(handler.customTags, Instance.this.local, handler.address, handler.path, handler.method)).decrement();
                    }
                }

                public void requestReset(Handler handler) {
                    ((LongAdder)VertxHttpClientMetrics.this.requests.get(handler.customTags, Instance.this.local, handler.address, handler.path, handler.method)).decrement();
                    handler.requestReset();
                }

                public void responseBegin(Handler requestMetric, HttpResponse response) {
                    requestMetric.response = response;
                }

                public void responseEnd(Handler handler, long bytesRead) {
                    String code = String.valueOf(handler.response.statusCode());
                    if (handler.responseEnded()) {
                        ((LongAdder)VertxHttpClientMetrics.this.requests.get(handler.customTags, Instance.this.local, handler.address, handler.path, handler.method)).decrement();
                    }
                    VertxHttpClientMetrics.this.responseCount.get(handler.customTags, Instance.this.local, handler.address, handler.path, handler.method, code).increment();
                    handler.timer.end(handler.customTags, Instance.this.local, handler.address, handler.path, handler.method, code);
                    VertxHttpClientMetrics.this.responseBytes.get(handler.customTags, Instance.this.local, handler.address, handler.path, handler.method, code).record((double)bytesRead);
                }
            };
        }

        public String connected(WebSocket webSocket) {
            String remote = webSocket.remoteAddress().toString();
            ((LongAdder)VertxHttpClientMetrics.this.wsConnections.get(this.local, remote)).increment();
            return remote;
        }

        public void disconnected(String remote) {
            ((LongAdder)VertxHttpClientMetrics.this.wsConnections.get(this.local, remote)).decrement();
        }

        @Override
        public void close() {
        }
    }
}

