/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.Labels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class TagsCache {
    private static final Object TAGS_DATA_FLYWEIGHT = new Object();
    private static final Object CACHE = new Object();

    public static Tags getOrCreate(Iterable<Tag> customTags, Label[] keys, String[] values) {
        ContextInternal context = (ContextInternal)Vertx.currentContext();
        if (context == null) {
            return TagsCache.createTags(customTags, keys, values);
        }
        Map<TagsData, Tags> cache = TagsCache.cache(context);
        try (TagsData cacheKey = TagsCache.flyweightKey(context, customTags, keys, values);){
            Tags tags = cache.get(cacheKey);
            if (tags == null) {
                tags = TagsCache.createTags(customTags, keys, values);
                cache.put(cacheKey.copy(), tags);
            }
            Tags tags2 = tags;
            return tags2;
        }
    }

    private static Map<TagsData, Tags> cache(ContextInternal context) {
        return (Map)context.contextData().computeIfAbsent(CACHE, v -> TagsCache.lruMap());
    }

    private static TagsData flyweightKey(ContextInternal context, Iterable<Tag> customTags, Label[] keys, String[] values) {
        TagsData tagsData = (TagsData)context.contextData().computeIfAbsent(TAGS_DATA_FLYWEIGHT, v -> new TagsData());
        tagsData.init(customTags, keys, values);
        return tagsData;
    }

    private static Tags createTags(Iterable<Tag> customTags, Label[] keys, String[] values) {
        return Labels.toTags(keys, values).and(customTags);
    }

    private static LinkedHashMap<TagsData, Tags> lruMap() {
        return new LinkedHashMap<TagsData, Tags>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 512;
            }
        };
    }

    private TagsCache() {
    }

    static final class TagsData
    implements AutoCloseable {
        Iterable<Tag> customTags;
        Label[] keys;
        String[] values;

        TagsData() {
        }

        TagsData(Iterable<Tag> customTags, Label[] keys, String[] values) {
            this.init(customTags, keys, values);
        }

        void init(Iterable<Tag> customTags, Label[] keys, String[] values) {
            this.customTags = customTags;
            this.keys = keys;
            this.values = values;
        }

        TagsData copy() {
            if (this.customTags == null) {
                return new TagsData(null, this.keys, this.values);
            }
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (Tag tag : this.customTags) {
                tags.add((Tag)new ImmutableTag(tag.getKey(), tag.getValue()));
            }
            tags.trimToSize();
            return new TagsData(tags, this.keys, this.values);
        }

        @Override
        public void close() {
            this.init(null, null, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagsData other = (TagsData)o;
            if (this.customTags == null) {
                if (other.customTags != null) {
                    return false;
                }
            } else {
                if (other.customTags == null) {
                    return false;
                }
                Iterator<Tag> iter = this.customTags.iterator();
                Iterator<Tag> otherIter = other.customTags.iterator();
                while (iter.hasNext()) {
                    if (!otherIter.hasNext()) {
                        return false;
                    }
                    Tag tag1 = iter.next();
                    Tag tag2 = otherIter.next();
                    if (tag1.getKey().equals(tag2.getKey()) && tag1.getValue().equals(tag2.getValue())) continue;
                    return false;
                }
                if (otherIter.hasNext()) {
                    return false;
                }
            }
            return Arrays.equals((Object[])this.keys, (Object[])other.keys) && Arrays.equals(this.values, other.values);
        }

        public int hashCode() {
            int result;
            if (this.customTags == null) {
                result = 0;
            } else {
                result = 1;
                for (Tag tag : this.customTags) {
                    result = 31 * result + tag.getKey().hashCode();
                    result = 31 * result + tag.getValue().hashCode();
                }
            }
            result = 31 * result + Arrays.hashCode((Object[])this.keys);
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }

        public String toString() {
            return "TagsData{customTags=" + StreamSupport.stream(this.customTags.spliterator(), false).collect(Collectors.toList()) + ", keys=" + Arrays.toString((Object[])this.keys) + ", values=" + Arrays.toString(this.values) + '}';
        }
    }
}

