/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.redis.RedisOptionsConverter;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=true)
public class RedisOptions
extends NetClientOptions {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 6379;
    private static final boolean DEFAULT_BINARY = false;
    private static final String DEFAULT_ADDRESS = "io.vertx.redis";
    private static final boolean DEFAULT_DOMAIN_SOCKET_OPTION = false;
    private String encoding;
    private String host;
    private int port;
    private boolean binary;
    private String address;
    private String domainSocketAddress;
    private boolean domainSocket;
    private String auth;
    private Integer select;
    private String masterName;
    private List<String> sentinels;

    public RedisOptions() {
        this.init();
    }

    public RedisOptions(RedisOptions other) {
        super((NetClientOptions)other);
        this.init();
        this.encoding = other.encoding;
        this.host = other.host;
        this.port = other.port;
        this.binary = other.binary;
        this.address = other.address;
        this.domainSocketAddress = other.domainSocketAddress;
        this.domainSocket = other.domainSocket;
        this.auth = other.auth;
        this.select = other.select;
        this.postInit();
    }

    public RedisOptions(JsonObject json) {
        super(json);
        this.init();
        RedisOptionsConverter.fromJson(json, this);
        this.postInit();
    }

    private void init() {
        this.encoding = DEFAULT_ENCODING;
        this.host = DEFAULT_HOST;
        this.port = 6379;
        this.binary = false;
        this.address = DEFAULT_ADDRESS;
        this.domainSocket = false;
        this.setTcpKeepAlive(true);
        this.setTcpNoDelay(true);
    }

    private void postInit() {
        if ("iso-8859-1".equalsIgnoreCase(this.encoding)) {
            this.binary = true;
            return;
        }
        if (this.binary) {
            this.encoding = "iso-8859-1";
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public RedisOptions setEncoding(String encoding) {
        this.encoding = encoding;
        this.postInit();
        return this;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public RedisOptions setBinary(boolean binary) {
        this.binary = binary;
        this.postInit();
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public RedisOptions setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public RedisOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RedisOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public String getAuth() {
        return this.auth;
    }

    public RedisOptions setAuth(String auth) {
        this.auth = auth;
        return this;
    }

    public Integer getSelect() {
        return this.select;
    }

    public RedisOptions setSelect(Integer select) {
        this.select = select;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public RedisOptions setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public RedisOptions addSentinel(String sentinelHostAndPort) {
        if (this.sentinels == null) {
            this.sentinels = new ArrayList<String>();
        }
        this.sentinels.add(sentinelHostAndPort);
        return this;
    }

    public List<String> getSentinels() {
        return this.sentinels;
    }

    public RedisOptions setSentinels(List<String> sentinels) {
        this.sentinels = sentinels;
        return this;
    }

    public RedisOptions setDomainSocketAddress(String domainSocketAddress) {
        this.domainSocketAddress = domainSocketAddress;
        return this;
    }

    public String getDomainSocketAddress() {
        return this.domainSocketAddress;
    }

    public RedisOptions setDomainSocket(boolean domainSocket) {
        this.domainSocket = domainSocket;
        return this;
    }

    public boolean isDomainSocket() {
        return this.domainSocket;
    }
}

