/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import zipkin.SpanDecoder;
import zipkin.collector.Collector;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.internal.Nullable;
import zipkin.internal.V2JsonSpanDecoder;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;

@RestController
@CrossOrigin(value={"${zipkin.query.allowed-origins:*}"})
@ConditionalOnProperty(name={"zipkin.collector.http.enabled"}, matchIfMissing=true)
public class ZipkinHttpCollector {
    static final ResponseEntity<?> SUCCESS = ResponseEntity.accepted().build();
    static final String APPLICATION_THRIFT = "application/x-thrift";
    static final SpanDecoder JSON2_DECODER = new V2JsonSpanDecoder();
    final CollectorMetrics metrics;
    final Collector collector;
    private static final ThreadLocal<byte[]> GZIP_BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[1024];
        }
    };

    @Autowired
    ZipkinHttpCollector(StorageComponent storage, CollectorSampler sampler, CollectorMetrics metrics) {
        this.metrics = metrics.forTransport("http");
        this.collector = Collector.builder(this.getClass()).storage(storage).sampler(sampler).metrics(this.metrics).build();
    }

    @RequestMapping(value={"/api/v2/spans"}, method={RequestMethod.POST})
    public ListenableFuture<ResponseEntity<?>> uploadSpansJson2(@RequestHeader(value="Content-Encoding", required=false) String encoding, @RequestBody byte[] body) {
        return this.validateAndStoreSpans(encoding, JSON2_DECODER, body);
    }

    @RequestMapping(value={"/api/v1/spans"}, method={RequestMethod.POST})
    public ListenableFuture<ResponseEntity<?>> uploadSpansJson(@RequestHeader(value="Content-Encoding", required=false) String encoding, @RequestBody byte[] body) {
        return this.validateAndStoreSpans(encoding, SpanDecoder.JSON_DECODER, body);
    }

    @RequestMapping(value={"/api/v1/spans"}, method={RequestMethod.POST}, consumes={"application/x-thrift"})
    public ListenableFuture<ResponseEntity<?>> uploadSpansThrift(@RequestHeader(value="Content-Encoding", required=false) String encoding, @RequestBody byte[] body) {
        return this.validateAndStoreSpans(encoding, SpanDecoder.THRIFT_DECODER, body);
    }

    ListenableFuture<ResponseEntity<?>> validateAndStoreSpans(String encoding, SpanDecoder decoder, byte[] body) {
        final SettableListenableFuture result = new SettableListenableFuture();
        this.metrics.incrementMessages();
        if (encoding != null && encoding.contains("gzip")) {
            try {
                body = ZipkinHttpCollector.gunzip(body);
            }
            catch (IOException e) {
                this.metrics.incrementMessagesDropped();
                result.set((Object)ResponseEntity.badRequest().body((Object)("Cannot gunzip spans: " + e.getMessage() + "\n")));
            }
        }
        this.collector.acceptSpans(body, decoder, (Callback)new Callback<Void>(){

            public void onSuccess(@Nullable Void value) {
                result.set(SUCCESS);
            }

            public void onError(Throwable t) {
                String message = t.getMessage() == null ? t.getClass().getSimpleName() : t.getMessage();
                result.set((Object)(t.getMessage() == null || message.startsWith("Cannot store") ? ResponseEntity.status((int)500).body((Object)(message + "\n")) : ResponseEntity.status((int)400).body((Object)(message + "\n"))));
            }
        });
        return result;
    }

    static byte[] gunzip(byte[] input) throws IOException {
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(input));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(input.length);){
            int len;
            byte[] buf = GZIP_BUFFER.get();
            while ((len = in.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

