/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.converter;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import me.ahoo.cosid.IdConverter;

public class PrefixIdConverter
implements IdConverter {
    private final String prefix;
    private final IdConverter idConverter;

    public PrefixIdConverter(String prefix, IdConverter idConverter) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix can not be null!");
        this.prefix = prefix;
        this.idConverter = idConverter;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    @Nonnull
    public String asString(long id) {
        String idStr = this.idConverter.asString(id);
        if (this.prefix.isEmpty()) {
            return idStr;
        }
        return this.prefix + idStr;
    }

    @Override
    public long asLong(@Nonnull String idString) {
        String idStr = idString.substring(this.prefix.length());
        return this.idConverter.asLong(idStr);
    }
}

