/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.cosid;

import com.google.common.base.Preconditions;
import me.ahoo.cosid.converter.Radix36IdConverter;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.converter.RadixIdConverter;
import me.ahoo.cosid.cosid.CosIdIdStateParser;
import me.ahoo.cosid.cosid.CosIdState;

public class RadixCosIdStateParser
implements CosIdIdStateParser {
    public static final RadixCosIdStateParser DEFAULT = RadixCosIdStateParser.ofRadix62(44, 20, 16);
    private final RadixIdConverter timestampConvert;
    private final RadixIdConverter machineConvert;
    private final RadixIdConverter sequenceConvert;

    public RadixCosIdStateParser(RadixIdConverter timestampConvert, RadixIdConverter machineConvert, RadixIdConverter sequenceConvert) {
        this.timestampConvert = timestampConvert;
        this.machineConvert = machineConvert;
        this.sequenceConvert = sequenceConvert;
    }

    @Override
    public CosIdState asState(String id) {
        int totalCharSize = this.timestampConvert.getCharSize() + this.machineConvert.getCharSize() + this.sequenceConvert.getCharSize();
        Preconditions.checkArgument((id.length() == totalCharSize ? 1 : 0) != 0, (String)"id[%s] length must equal to totalCharSize:[%s].", (Object)id, (int)totalCharSize);
        String timestampPart = id.substring(0, this.timestampConvert.getCharSize());
        String machineIdPart = id.substring(this.timestampConvert.getCharSize(), this.timestampConvert.getCharSize() + this.machineConvert.getCharSize());
        String sequencePart = id.substring(this.timestampConvert.getCharSize() + this.machineConvert.getCharSize());
        return new CosIdState(this.timestampConvert.asLong(timestampPart), (int)this.machineConvert.asLong(machineIdPart), (int)this.sequenceConvert.asLong(sequencePart));
    }

    @Override
    public String asString(CosIdState cosIdState) {
        return this.asString(cosIdState.getTimestamp(), cosIdState.getMachineId(), cosIdState.getSequence());
    }

    @Override
    public String asString(long lastTimestamp, int machineId, int sequence) {
        return this.timestampConvert.asString(lastTimestamp) + this.machineConvert.asString(machineId) + this.sequenceConvert.asString(sequence);
    }

    static RadixCosIdStateParser ofRadix62(int timestampBits, int machineIdBits, int sequenceBits) {
        int radix = 62;
        int timestampMaxCharSize = RadixIdConverter.maxCharSize(62, timestampBits);
        int machineIdMaxCharSize = RadixIdConverter.maxCharSize(62, machineIdBits);
        int sequenceMaxCharSize = RadixIdConverter.maxCharSize(62, sequenceBits);
        return new RadixCosIdStateParser(new Radix62IdConverter(true, timestampMaxCharSize), new Radix62IdConverter(true, machineIdMaxCharSize), new Radix62IdConverter(true, sequenceMaxCharSize));
    }

    static RadixCosIdStateParser ofRadix36(int timestampBits, int machineIdBits, int sequenceBits) {
        int radix = 36;
        int timestampMaxCharSize = RadixIdConverter.maxCharSize(36, timestampBits);
        int machineIdMaxCharSize = RadixIdConverter.maxCharSize(36, machineIdBits);
        int sequenceMaxCharSize = RadixIdConverter.maxCharSize(36, sequenceBits);
        return new RadixCosIdStateParser(new Radix36IdConverter(true, timestampMaxCharSize), new Radix36IdConverter(true, machineIdMaxCharSize), new Radix36IdConverter(true, sequenceMaxCharSize));
    }
}

