/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake;

import me.ahoo.cosid.snowflake.MillisecondSnowflakeId;
import me.ahoo.cosid.snowflake.SecondSnowflakeId;
import me.ahoo.cosid.snowflake.SnowflakeId;

public final class SafeJavaScriptSnowflakeId {
    public static final int JAVA_SCRIPT_MAX_SAFE_NUMBER_BIT = 53;
    public static final long JAVA_SCRIPT_MAX_SAFE_NUMBER = 0x1FFFFFFFFFFFFFL;

    public static boolean isSafeJavaScript(long id) {
        return id < 0x1FFFFFFFFFFFFFL;
    }

    public static MillisecondSnowflakeId ofMillisecond(long epoch, int timestampBit, int machineBit, int sequenceBit, int machineId, long sequenceResetThreshold) {
        SafeJavaScriptSnowflakeId.checkTotalBit(timestampBit, machineBit, sequenceBit);
        return new MillisecondSnowflakeId(epoch, timestampBit, machineBit, sequenceBit, machineId, sequenceResetThreshold);
    }

    public static MillisecondSnowflakeId ofMillisecond(int machineId) {
        int timestampBit = 41;
        int machineBit = 3;
        int sequenceBit = 9;
        SafeJavaScriptSnowflakeId.checkTotalBit(41, 3, 9);
        return SafeJavaScriptSnowflakeId.ofMillisecond(1577203200L, 41, 3, 9, machineId, SnowflakeId.defaultSequenceResetThreshold(9));
    }

    public static SecondSnowflakeId ofSecond(long epoch, int timestampBit, int machineBit, int sequenceBit, int machineId, long sequenceResetThreshold) {
        SafeJavaScriptSnowflakeId.checkTotalBit(timestampBit, machineBit, sequenceBit);
        return new SecondSnowflakeId(epoch, timestampBit, machineBit, sequenceBit, machineId, sequenceResetThreshold);
    }

    public static SecondSnowflakeId ofSecond(int machineId) {
        int timestampBit = 31;
        int machineBit = 3;
        int sequenceBit = 19;
        SafeJavaScriptSnowflakeId.checkTotalBit(31, 3, 19);
        return SafeJavaScriptSnowflakeId.ofSecond(1577203200L, 31, 3, 19, machineId, SnowflakeId.defaultSequenceResetThreshold(19));
    }

    private static void checkTotalBit(int timestampBit, int machineBit, int sequenceBit) {
        if (timestampBit + machineBit + sequenceBit > 53) {
            throw new IllegalArgumentException(String.format("total bit can't be greater than JAVA_SCRIPT_MAX_SAFE_NUMBER_BIT:[%s].", 53));
        }
    }
}

