/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package me.snowdrop.istio.client.internal.handler;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.ServiceRoleOperationImpl;

import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRole;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ServiceRoleHandler implements ResourceHandler<ServiceRole, ServiceRoleBuilder> {
  @Override
  public String getKind() {
    return ServiceRole.class.getSimpleName();
  }

  @Override
  public ServiceRole create(OkHttpClient client, Config config, String namespace, ServiceRole item) {
    return new ServiceRoleOperationImpl(client, config, "rbac.istio.io", "v1alpha1", namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).create();
  }

  @Override
  public ServiceRole replace(OkHttpClient client, Config config, String namespace, ServiceRole item) {
    return new ServiceRoleOperationImpl(client, config,"rbac.istio.io", "v1alpha1", namespace, null, true, item, null, true, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).replace(item);
  }

  @Override
  public ServiceRole reload(OkHttpClient client, Config config, String namespace, ServiceRole item) {
    return new ServiceRoleOperationImpl(client, config, "rbac.istio.io", "v1alpha1", namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).fromServer().get();
  }

  @Override
  public ServiceRoleBuilder edit(ServiceRole item) {
    return new ServiceRoleBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, ServiceRole item) {
    return new ServiceRoleOperationImpl(client, config,"rbac.istio.io", "v1alpha1", namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).delete(item);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceRole item, Watcher<ServiceRole> watcher) {
    return new ServiceRoleOperationImpl(client, config, "rbac.istio.io", "v1alpha1", namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ServiceRole item, String resourceVersion, Watcher<ServiceRole> watcher) {
    return new ServiceRoleOperationImpl(client, config,"rbac.istio.io", "v1alpha1", namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).watch(resourceVersion, watcher);
  }

  @Override
  public ServiceRole waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceRole item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceRoleOperationImpl(client, config, "rbac.istio.io", "v1alpha1", namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).waitUntilReady(amount, timeUnit);
  }
}
