/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPSettings;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPSettingsFluent;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPSettingsFluentImpl;

public class HTTPSettingsBuilder
extends HTTPSettingsFluentImpl<HTTPSettingsBuilder>
implements VisitableBuilder<HTTPSettings, HTTPSettingsBuilder> {
    HTTPSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPSettingsBuilder() {
        this(true);
    }

    public HTTPSettingsBuilder(Boolean validationEnabled) {
        this(new HTTPSettings(), validationEnabled);
    }

    public HTTPSettingsBuilder(HTTPSettingsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HTTPSettingsBuilder(HTTPSettingsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPSettings(), validationEnabled);
    }

    public HTTPSettingsBuilder(HTTPSettingsFluent<?> fluent, HTTPSettings instance) {
        this(fluent, instance, true);
    }

    public HTTPSettingsBuilder(HTTPSettingsFluent<?> fluent, HTTPSettings instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests());
        fluent.withHttp2MaxRequests(instance.getHttp2MaxRequests());
        fluent.withIdleTimeout(instance.getIdleTimeout());
        fluent.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection());
        fluent.withMaxRetries(instance.getMaxRetries());
        this.validationEnabled = validationEnabled;
    }

    public HTTPSettingsBuilder(HTTPSettings instance) {
        this(instance, (Boolean)true);
    }

    public HTTPSettingsBuilder(HTTPSettings instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests());
        this.withHttp2MaxRequests(instance.getHttp2MaxRequests());
        this.withIdleTimeout(instance.getIdleTimeout());
        this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection());
        this.withMaxRetries(instance.getMaxRetries());
        this.validationEnabled = validationEnabled;
    }

    public HTTPSettings build() {
        HTTPSettings buildable = new HTTPSettings(this.fluent.getHttp1MaxPendingRequests(), this.fluent.getHttp2MaxRequests(), this.fluent.getIdleTimeout(), this.fluent.getMaxRequestsPerConnection(), this.fluent.getMaxRetries());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPSettingsBuilder that = (HTTPSettingsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

