/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.networking.v1alpha3.ListenerMatch;
import me.snowdrop.istio.api.networking.v1alpha3.ListenerMatchFluent;
import me.snowdrop.istio.api.networking.v1alpha3.ListenerProtocol;
import me.snowdrop.istio.api.networking.v1alpha3.ListenerType;

public class ListenerMatchFluentImpl<A extends ListenerMatchFluent<A>>
extends BaseFluent<A>
implements ListenerMatchFluent<A> {
    private List<String> address;
    private ListenerProtocol listenerProtocol;
    private ListenerType listenerType;
    private String portNamePrefix;
    private Integer portNumber;

    public ListenerMatchFluentImpl() {
    }

    public ListenerMatchFluentImpl(ListenerMatch instance) {
        this.withAddress(instance.getAddress());
        this.withListenerProtocol(instance.getListenerProtocol());
        this.withListenerType(instance.getListenerType());
        this.withPortNamePrefix(instance.getPortNamePrefix());
        this.withPortNumber(instance.getPortNumber());
    }

    @Override
    public A addToAddress(int index, String item) {
        if (this.address == null) {
            this.address = new ArrayList<String>();
        }
        this.address.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAddress(int index, String item) {
        if (this.address == null) {
            this.address = new ArrayList<String>();
        }
        this.address.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAddress(String ... items) {
        if (this.address == null) {
            this.address = new ArrayList<String>();
        }
        for (String item : items) {
            this.address.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddress(Collection<String> items) {
        if (this.address == null) {
            this.address = new ArrayList<String>();
        }
        for (String item : items) {
            this.address.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddress(String ... items) {
        for (String item : items) {
            if (this.address == null) continue;
            this.address.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddress(Collection<String> items) {
        for (String item : items) {
            if (this.address == null) continue;
            this.address.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAddress() {
        return this.address;
    }

    @Override
    public String getAddress(int index) {
        return this.address.get(index);
    }

    @Override
    public String getFirstAddress() {
        return this.address.get(0);
    }

    @Override
    public String getLastAddress() {
        return this.address.get(this.address.size() - 1);
    }

    @Override
    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item : this.address) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<String> predicate) {
        for (String item : this.address) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddress(List<String> address) {
        if (this.address != null) {
            this._visitables.get((Object)"address").removeAll(this.address);
        }
        if (address != null) {
            this.address = new ArrayList<String>();
            for (String item : address) {
                this.addToAddress(item);
            }
        } else {
            this.address = null;
        }
        return (A)this;
    }

    @Override
    public A withAddress(String ... address) {
        if (this.address != null) {
            this.address.clear();
        }
        if (address != null) {
            for (String item : address) {
                this.addToAddress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    @Override
    public A addNewAddress(String arg1) {
        return this.addToAddress(new String(arg1));
    }

    @Override
    public A addNewAddress(StringBuilder arg1) {
        return this.addToAddress(new String(arg1));
    }

    @Override
    public A addNewAddress(StringBuffer arg1) {
        return this.addToAddress(new String(arg1));
    }

    @Override
    public ListenerProtocol getListenerProtocol() {
        return this.listenerProtocol;
    }

    @Override
    public A withListenerProtocol(ListenerProtocol listenerProtocol) {
        this.listenerProtocol = listenerProtocol;
        return (A)this;
    }

    @Override
    public Boolean hasListenerProtocol() {
        return this.listenerProtocol != null;
    }

    @Override
    public ListenerType getListenerType() {
        return this.listenerType;
    }

    @Override
    public A withListenerType(ListenerType listenerType) {
        this.listenerType = listenerType;
        return (A)this;
    }

    @Override
    public Boolean hasListenerType() {
        return this.listenerType != null;
    }

    @Override
    public String getPortNamePrefix() {
        return this.portNamePrefix;
    }

    @Override
    public A withPortNamePrefix(String portNamePrefix) {
        this.portNamePrefix = portNamePrefix;
        return (A)this;
    }

    @Override
    public Boolean hasPortNamePrefix() {
        return this.portNamePrefix != null;
    }

    @Override
    public A withNewPortNamePrefix(String arg1) {
        return this.withPortNamePrefix(new String(arg1));
    }

    @Override
    public A withNewPortNamePrefix(StringBuilder arg1) {
        return this.withPortNamePrefix(new String(arg1));
    }

    @Override
    public A withNewPortNamePrefix(StringBuffer arg1) {
        return this.withPortNamePrefix(new String(arg1));
    }

    @Override
    public Integer getPortNumber() {
        return this.portNumber;
    }

    @Override
    public A withPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
        return (A)this;
    }

    @Override
    public Boolean hasPortNumber() {
        return this.portNumber != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListenerMatchFluentImpl that = (ListenerMatchFluentImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.listenerProtocol != null ? !this.listenerProtocol.equals((Object)that.listenerProtocol) : that.listenerProtocol != null) {
            return false;
        }
        if (this.listenerType != null ? !this.listenerType.equals((Object)that.listenerType) : that.listenerType != null) {
            return false;
        }
        if (this.portNamePrefix != null ? !this.portNamePrefix.equals(that.portNamePrefix) : that.portNamePrefix != null) {
            return false;
        }
        return !(this.portNumber != null ? !this.portNumber.equals(that.portNumber) : that.portNumber != null);
    }
}

