/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.snowdrop.istio.api.networking.v1alpha3.IstioEgressListener;
import me.snowdrop.istio.api.networking.v1alpha3.IstioEgressListenerBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.IstioEgressListenerFluentImpl;
import me.snowdrop.istio.api.networking.v1alpha3.IstioIngressListener;
import me.snowdrop.istio.api.networking.v1alpha3.IstioIngressListenerBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.IstioIngressListenerFluentImpl;
import me.snowdrop.istio.api.networking.v1alpha3.SidecarSpec;
import me.snowdrop.istio.api.networking.v1alpha3.SidecarSpecFluent;
import me.snowdrop.istio.api.networking.v1alpha3.WorkloadSelector;
import me.snowdrop.istio.api.networking.v1alpha3.WorkloadSelectorBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.WorkloadSelectorFluentImpl;

public class SidecarSpecFluentImpl<A extends SidecarSpecFluent<A>>
extends BaseFluent<A>
implements SidecarSpecFluent<A> {
    private List<IstioEgressListenerBuilder> egress;
    private List<IstioIngressListenerBuilder> ingress;
    private WorkloadSelectorBuilder workloadSelector;

    public SidecarSpecFluentImpl() {
    }

    public SidecarSpecFluentImpl(SidecarSpec instance) {
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withWorkloadSelector(instance.getWorkloadSelector());
    }

    @Override
    public A addToEgress(int index, IstioEgressListener item) {
        if (this.egress == null) {
            this.egress = new ArrayList<IstioEgressListenerBuilder>();
        }
        IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
        this._visitables.get((Object)"egress").add(index >= 0 ? index : this._visitables.get((Object)"egress").size(), builder);
        this.egress.add(index >= 0 ? index : this.egress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEgress(int index, IstioEgressListener item) {
        if (this.egress == null) {
            this.egress = new ArrayList<IstioEgressListenerBuilder>();
        }
        IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"egress").size()) {
            this._visitables.get((Object)"egress").add(builder);
        } else {
            this._visitables.get((Object)"egress").set(index, builder);
        }
        if (index < 0 || index >= this.egress.size()) {
            this.egress.add(builder);
        } else {
            this.egress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEgress(IstioEgressListener ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList<IstioEgressListenerBuilder>();
        }
        for (IstioEgressListener item : items) {
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgress(Collection<IstioEgressListener> items) {
        if (this.egress == null) {
            this.egress = new ArrayList<IstioEgressListenerBuilder>();
        }
        for (IstioEgressListener item : items) {
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgress(IstioEgressListener ... items) {
        for (IstioEgressListener item : items) {
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
            this._visitables.get((Object)"egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgress(Collection<IstioEgressListener> items) {
        for (IstioEgressListener item : items) {
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
            this._visitables.get((Object)"egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEgress(Predicate<IstioEgressListenerBuilder> predicate) {
        if (this.egress == null) {
            return (A)this;
        }
        Iterator<IstioEgressListenerBuilder> each = this.egress.iterator();
        List visitables = this._visitables.get((Object)"egress");
        while (each.hasNext()) {
            IstioEgressListenerBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IstioEgressListener> getEgress() {
        return SidecarSpecFluentImpl.build(this.egress);
    }

    @Override
    public List<IstioEgressListener> buildEgress() {
        return SidecarSpecFluentImpl.build(this.egress);
    }

    @Override
    public IstioEgressListener buildEgress(int index) {
        return this.egress.get(index).build();
    }

    @Override
    public IstioEgressListener buildFirstEgress() {
        return this.egress.get(0).build();
    }

    @Override
    public IstioEgressListener buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    @Override
    public IstioEgressListener buildMatchingEgress(Predicate<IstioEgressListenerBuilder> predicate) {
        for (IstioEgressListenerBuilder item : this.egress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgress(Predicate<IstioEgressListenerBuilder> predicate) {
        for (IstioEgressListenerBuilder item : this.egress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgress(List<IstioEgressListener> egress) {
        if (this.egress != null) {
            this._visitables.get((Object)"egress").removeAll(this.egress);
        }
        if (egress != null) {
            this.egress = new ArrayList<IstioEgressListenerBuilder>();
            for (IstioEgressListener item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)this;
    }

    @Override
    public A withEgress(IstioEgressListener ... egress) {
        if (this.egress != null) {
            this.egress.clear();
        }
        if (egress != null) {
            for (IstioEgressListener item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    @Override
    public SidecarSpecFluent.EgressNested<A> addNewEgress() {
        return new EgressNestedImpl();
    }

    @Override
    public SidecarSpecFluent.EgressNested<A> addNewEgressLike(IstioEgressListener item) {
        return new EgressNestedImpl(-1, item);
    }

    @Override
    public SidecarSpecFluent.EgressNested<A> setNewEgressLike(int index, IstioEgressListener item) {
        return new EgressNestedImpl(index, item);
    }

    @Override
    public SidecarSpecFluent.EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public SidecarSpecFluent.EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    @Override
    public SidecarSpecFluent.EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public SidecarSpecFluent.EgressNested<A> editMatchingEgress(Predicate<IstioEgressListenerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.apply((Object)this.egress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public A addToIngress(int index, IstioIngressListener item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<IstioIngressListenerBuilder>();
        }
        IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
        this._visitables.get((Object)"ingress").add(index >= 0 ? index : this._visitables.get((Object)"ingress").size(), builder);
        this.ingress.add(index >= 0 ? index : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(int index, IstioIngressListener item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<IstioIngressListenerBuilder>();
        }
        IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"ingress").size()) {
            this._visitables.get((Object)"ingress").add(builder);
        } else {
            this._visitables.get((Object)"ingress").set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(IstioIngressListener ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<IstioIngressListenerBuilder>();
        }
        for (IstioIngressListener item : items) {
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<IstioIngressListener> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<IstioIngressListenerBuilder>();
        }
        for (IstioIngressListener item : items) {
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(IstioIngressListener ... items) {
        for (IstioIngressListener item : items) {
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
            this._visitables.get((Object)"ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<IstioIngressListener> items) {
        for (IstioIngressListener item : items) {
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
            this._visitables.get((Object)"ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<IstioIngressListenerBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<IstioIngressListenerBuilder> each = this.ingress.iterator();
        List visitables = this._visitables.get((Object)"ingress");
        while (each.hasNext()) {
            IstioIngressListenerBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IstioIngressListener> getIngress() {
        return SidecarSpecFluentImpl.build(this.ingress);
    }

    @Override
    public List<IstioIngressListener> buildIngress() {
        return SidecarSpecFluentImpl.build(this.ingress);
    }

    @Override
    public IstioIngressListener buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public IstioIngressListener buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public IstioIngressListener buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public IstioIngressListener buildMatchingIngress(Predicate<IstioIngressListenerBuilder> predicate) {
        for (IstioIngressListenerBuilder item : this.ingress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<IstioIngressListenerBuilder> predicate) {
        for (IstioIngressListenerBuilder item : this.ingress) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<IstioIngressListener> ingress) {
        if (this.ingress != null) {
            this._visitables.get((Object)"ingress").removeAll(this.ingress);
        }
        if (ingress != null) {
            this.ingress = new ArrayList<IstioIngressListenerBuilder>();
            for (IstioIngressListener item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(IstioIngressListener ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
        }
        if (ingress != null) {
            for (IstioIngressListener item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public SidecarSpecFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public SidecarSpecFluent.IngressNested<A> addNewIngressLike(IstioIngressListener item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public SidecarSpecFluent.IngressNested<A> setNewIngressLike(int index, IstioIngressListener item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public SidecarSpecFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public SidecarSpecFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public SidecarSpecFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public SidecarSpecFluent.IngressNested<A> editMatchingIngress(Predicate<IstioIngressListenerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.apply((Object)this.ingress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    @Deprecated
    public WorkloadSelector getWorkloadSelector() {
        return this.workloadSelector != null ? this.workloadSelector.build() : null;
    }

    @Override
    public WorkloadSelector buildWorkloadSelector() {
        return this.workloadSelector != null ? this.workloadSelector.build() : null;
    }

    @Override
    public A withWorkloadSelector(WorkloadSelector workloadSelector) {
        this._visitables.get((Object)"workloadSelector").remove(this.workloadSelector);
        if (workloadSelector != null) {
            this.workloadSelector = new WorkloadSelectorBuilder(workloadSelector);
            this._visitables.get((Object)"workloadSelector").add(this.workloadSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWorkloadSelector() {
        return this.workloadSelector != null;
    }

    @Override
    public SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector() {
        return new WorkloadSelectorNestedImpl();
    }

    @Override
    public SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item) {
        return new WorkloadSelectorNestedImpl(item);
    }

    @Override
    public SidecarSpecFluent.WorkloadSelectorNested<A> editWorkloadSelector() {
        return this.withNewWorkloadSelectorLike(this.getWorkloadSelector());
    }

    @Override
    public SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector() {
        return this.withNewWorkloadSelectorLike(this.getWorkloadSelector() != null ? this.getWorkloadSelector() : new WorkloadSelectorBuilder().build());
    }

    @Override
    public SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item) {
        return this.withNewWorkloadSelectorLike(this.getWorkloadSelector() != null ? this.getWorkloadSelector() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidecarSpecFluentImpl that = (SidecarSpecFluentImpl)o;
        if (this.egress != null ? !this.egress.equals(that.egress) : that.egress != null) {
            return false;
        }
        if (this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null) {
            return false;
        }
        return !(this.workloadSelector != null ? !this.workloadSelector.equals(that.workloadSelector) : that.workloadSelector != null);
    }

    public class WorkloadSelectorNestedImpl<N>
    extends WorkloadSelectorFluentImpl<SidecarSpecFluent.WorkloadSelectorNested<N>>
    implements SidecarSpecFluent.WorkloadSelectorNested<N>,
    Nested<N> {
        private final WorkloadSelectorBuilder builder;

        WorkloadSelectorNestedImpl(WorkloadSelector item) {
            this.builder = new WorkloadSelectorBuilder(this, item);
        }

        WorkloadSelectorNestedImpl() {
            this.builder = new WorkloadSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)SidecarSpecFluentImpl.this.withWorkloadSelector(this.builder.build());
        }

        @Override
        public N endWorkloadSelector() {
            return this.and();
        }
    }

    public class IngressNestedImpl<N>
    extends IstioIngressListenerFluentImpl<SidecarSpecFluent.IngressNested<N>>
    implements SidecarSpecFluent.IngressNested<N>,
    Nested<N> {
        private final IstioIngressListenerBuilder builder;
        private final int index;

        IngressNestedImpl(int index, IstioIngressListener item) {
            this.index = index;
            this.builder = new IstioIngressListenerBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new IstioIngressListenerBuilder(this);
        }

        @Override
        public N and() {
            return (N)SidecarSpecFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }

    public class EgressNestedImpl<N>
    extends IstioEgressListenerFluentImpl<SidecarSpecFluent.EgressNested<N>>
    implements SidecarSpecFluent.EgressNested<N>,
    Nested<N> {
        private final IstioEgressListenerBuilder builder;
        private final int index;

        EgressNestedImpl(int index, IstioEgressListener item) {
            this.index = index;
            this.builder = new IstioEgressListenerBuilder(this, item);
        }

        EgressNestedImpl() {
            this.index = -1;
            this.builder = new IstioEgressListenerBuilder(this);
        }

        @Override
        public N and() {
            return (N)SidecarSpecFluentImpl.this.setToEgress(this.index, this.builder.build());
        }

        @Override
        public N endEgress() {
            return this.and();
        }
    }
}

