/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRole;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBuilder;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleFluentImpl;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleList;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleListFluent;

public class ServiceRoleListFluentImpl<A extends ServiceRoleListFluent<A>>
extends BaseFluent<A>
implements ServiceRoleListFluent<A> {
    private String apiVersion;
    private List<ServiceRoleBuilder> items;
    private String kind;
    private ListMeta metadata;

    public ServiceRoleListFluentImpl() {
    }

    public ServiceRoleListFluentImpl(ServiceRoleList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, ServiceRole item) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceRoleBuilder>();
        }
        ServiceRoleBuilder builder = new ServiceRoleBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ServiceRole item) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceRoleBuilder>();
        }
        ServiceRoleBuilder builder = new ServiceRoleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ServiceRole ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceRoleBuilder>();
        }
        for (ServiceRole item : items) {
            ServiceRoleBuilder builder = new ServiceRoleBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ServiceRole> items) {
        if (this.items == null) {
            this.items = new ArrayList<ServiceRoleBuilder>();
        }
        for (ServiceRole item : items) {
            ServiceRoleBuilder builder = new ServiceRoleBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ServiceRole ... items) {
        for (ServiceRole item : items) {
            ServiceRoleBuilder builder = new ServiceRoleBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ServiceRole> items) {
        for (ServiceRole item : items) {
            ServiceRoleBuilder builder = new ServiceRoleBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ServiceRoleBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ServiceRoleBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ServiceRoleBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServiceRole> getItems() {
        return ServiceRoleListFluentImpl.build(this.items);
    }

    @Override
    public List<ServiceRole> buildItems() {
        return ServiceRoleListFluentImpl.build(this.items);
    }

    @Override
    public ServiceRole buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ServiceRole buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ServiceRole buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ServiceRole buildMatchingItem(Predicate<ServiceRoleBuilder> predicate) {
        for (ServiceRoleBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ServiceRoleBuilder> predicate) {
        for (ServiceRoleBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ServiceRole> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ServiceRoleBuilder>();
            for (ServiceRole item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ServiceRole ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ServiceRole item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ServiceRoleListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ServiceRoleListFluent.ItemsNested<A> addNewItemLike(ServiceRole item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ServiceRoleListFluent.ItemsNested<A> setNewItemLike(int index, ServiceRole item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ServiceRoleListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceRoleListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ServiceRoleListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceRoleListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceRoleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply((Object)this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceRoleListFluentImpl that = (ServiceRoleListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends ServiceRoleFluentImpl<ServiceRoleListFluent.ItemsNested<N>>
    implements ServiceRoleListFluent.ItemsNested<N>,
    Nested<N> {
        private final ServiceRoleBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ServiceRole item) {
            this.index = index;
            this.builder = new ServiceRoleBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceRoleBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceRoleListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

