/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import net.bull.javamelody.internal.model.MBeans;

public class PrometheusMBeanTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String jmxValue;
    private String metricName;
    private MetricType metricType;
    private String metricHelp;

    public String getJmxValue() {
        return this.jmxValue;
    }

    public void setJmxValue(String jmxValue) {
        this.jmxValue = jmxValue;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MetricType metricType) {
        this.metricType = metricType;
    }

    public String getMetricHelp() {
        return this.metricHelp;
    }

    public void setMetricHelp(String metricHelp) {
        this.metricHelp = metricHelp;
        if (this.metricHelp != null) {
            this.metricHelp = this.metricHelp.trim().replace('\n', ' ').replace('\r', ' ');
        }
    }

    public int doEndTag() throws JspException {
        assert (this.jmxValue != null);
        assert (this.metricName != null);
        assert (this.metricType != null);
        String value = MBeans.getConvertedAttributes(this.jmxValue);
        try {
            if (this.metricHelp == null) {
                this.println("# HELP ", this.metricName, " MBean ", this.jmxValue);
            } else {
                this.println("# HELP ", this.metricName, " ", this.metricHelp);
            }
            this.println("# TYPE ", this.metricName, " ", this.metricType.name());
            this.println(this.metricName, " ", value);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return super.doEndTag();
    }

    private void println(String ... strings) throws IOException {
        JspWriter out = this.pageContext.getOut();
        for (String s : strings) {
            out.print(s);
        }
        out.print('\n');
    }

    public static enum MetricType {
        counter,
        gauge,
        histogram,
        summary;

    }
}

