/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.XStreamAlias;

public enum TransportFormat {
    SERIALIZED("application/x-java-serialized-object"),
    XML("text/xml; charset=utf-8"),
    JSON("application/json"),
    GSON("application/json");

    private static final String NULL_VALUE = "null";
    private final String code;
    private final String mimeType;

    private TransportFormat(String mimeType) {
        this.mimeType = mimeType;
        this.code = this.toString().toLowerCase(Locale.ENGLISH);
    }

    public static TransportFormat valueOfIgnoreCase(String transportFormat) {
        return TransportFormat.valueOf(transportFormat.toUpperCase(Locale.ENGLISH).trim());
    }

    public static boolean isATransportFormat(String format) {
        if (format == null) {
            return false;
        }
        String upperCase = format.toUpperCase(Locale.ENGLISH).trim();
        for (TransportFormat transportFormat : TransportFormat.values()) {
            if (!transportFormat.toString().equals(upperCase)) continue;
            return true;
        }
        return false;
    }

    public String getCode() {
        return this.code;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void checkDependencies() throws IOException {
        if (this == XML || this == JSON) {
            try {
                Class.forName("com.thoughtworks.xstream.XStream");
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Classes of the XStream library not found. Add the XStream dependency in your webapp for the XML or JSON formats.", e);
            }
        }
        if (this == XML) {
            try {
                Class.forName("org.xmlpull.v1.XmlPullParser");
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Classes of the XPP3 library not found. Add the XPP3 dependency in your webapp for the XML format.", e);
            }
        }
        if (this == GSON) {
            try {
                Class.forName("com.google.gson.Gson");
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Classes of the Gson library not found. Add the Gson dependency in your webapp for the GSON format.", e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeSerializableTo(Serializable serializable, OutputStream output) throws IOException {
        nonNullSerializable = serializable == null ? "null" : serializable;
        bufferedOutput = new BufferedOutputStream(output);
        switch (1.$SwitchMap$net$bull$javamelody$internal$model$TransportFormat[this.ordinal()]) {
            case 1: {
                out = new ObjectOutputStream(bufferedOutput);
                var6_6 = null;
                out.writeObject(nonNullSerializable);
                if (out == null) break;
                if (var6_6 == null) ** GOTO lbl17
                try {
                    out.close();
                }
                catch (Throwable var7_7) {
                    var6_6.addSuppressed(var7_7);
                }
                break;
lbl17:
                // 1 sources

                out.close();
                break;
                catch (Throwable var7_8) {
                    try {
                        var6_6 = var7_8;
                        throw var7_8;
                    }
                    catch (Throwable var8_9) {
                        if (out != null) {
                            if (var6_6 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable var9_10) {
                                    var6_6.addSuppressed(var9_10);
                                }
                            } else {
                                out.close();
                            }
                        }
                        throw var8_9;
                    }
                }
            }
            case 2: {
                XmlIO.writeToXml((Serializable)nonNullSerializable, bufferedOutput);
                break;
            }
            case 3: {
                XmlIO.writeToJson((Serializable)nonNullSerializable, bufferedOutput);
                break;
            }
            case 4: {
                GsonIO.writeToGson((Serializable)nonNullSerializable, bufferedOutput);
                break;
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    Serializable readSerializableFrom(InputStream input) throws IOException, ClassNotFoundException {
        bufferedInput = new BufferedInputStream(input);
        switch (1.$SwitchMap$net$bull$javamelody$internal$model$TransportFormat[this.ordinal()]) {
            case 1: {
                in = TransportFormat.createObjectInputStream(bufferedInput);
                var5_4 = null;
                result = in.readObject();
                if (in == null) break;
                if (var5_4 == null) ** GOTO lbl16
                try {
                    in.close();
                }
                catch (Throwable var6_6) {
                    var5_4.addSuppressed(var6_6);
                }
                break;
lbl16:
                // 1 sources

                in.close();
                break;
                catch (Throwable var6_7) {
                    try {
                        var5_4 = var6_7;
                        throw var6_7;
                    }
                    catch (Throwable var7_8) {
                        if (in != null) {
                            if (var5_4 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable var8_9) {
                                    var5_4.addSuppressed(var8_9);
                                }
                            } else {
                                in.close();
                            }
                        }
                        throw var7_8;
                    }
                }
            }
            case 2: {
                result = XmlIO.readFromXml(bufferedInput);
                break;
            }
            case 3: {
                throw new UnsupportedOperationException();
            }
            case 4: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
        if ("null".equals(result)) {
            return null;
        }
        return (Serializable)result;
    }

    static ObjectInputStream createObjectInputStream(InputStream input) throws IOException {
        return new MyObjectInputStream(input);
    }

    private static class MyObjectInputStream
    extends ObjectInputStream {
        private static final String PACKAGE_NAME = TransportFormat.class.getName().substring(0, TransportFormat.class.getName().length() - TransportFormat.class.getSimpleName().length() - 1);

        MyObjectInputStream(InputStream input) throws IOException {
            super(input);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            int i = 0;
            if (name.indexOf("[[") == 0) {
                ++i;
            }
            if (name.indexOf("[L", i) == i) {
                i += 2;
            }
            if (name.indexOf("java.lang.", i) == i || name.indexOf("java.util.", i) == i || name.indexOf("java.io.", i) == i || name.indexOf(PACKAGE_NAME, i) == i || name.length() <= 2) {
                return super.resolveClass(desc);
            }
            if (name.indexOf("net.bull.javamelody", i) == i) {
                return Class.forName(name.replace("net.bull.javamelody", "net.bull.javamelody.internal.model"));
            }
            throw new ClassNotFoundException(name);
        }
    }

    private static final class GsonIO {
        private static final String GSON_CHARSET_NAME = "UTF-8";

        private GsonIO() {
        }

        static void writeToGson(Serializable serializable, BufferedOutputStream bufferedOutput) throws IOException {
            JsonSerializer<StackTraceElement> stackTraceElementJsonSerializer = new JsonSerializer<StackTraceElement>(){

                public JsonElement serialize(StackTraceElement src, Type typeOfSrc, JsonSerializationContext context) {
                    return new JsonPrimitive(src.toString());
                }
            };
            Gson gson = new GsonBuilder().registerTypeAdapter(StackTraceElement.class, (Object)stackTraceElementJsonSerializer).create();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedOutput, GSON_CHARSET_NAME);){
                gson.toJson((Object)serializable, (Appendable)writer);
            }
        }
    }

    private static final class XmlIO {
        private static final String PACKAGE_NAME = TransportFormat.class.getName().substring(0, TransportFormat.class.getName().length() - TransportFormat.class.getSimpleName().length() - 1);
        private static final String XML_CHARSET_NAME = "utf-8";

        private XmlIO() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void writeToXml(Serializable serializable, BufferedOutputStream bufferedOutput) throws IOException {
            XStream xstream = XmlIO.createXStream(false);
            try (CompactWriter writer = new CompactWriter((Writer)new OutputStreamWriter((OutputStream)bufferedOutput, XML_CHARSET_NAME));){
                xstream.marshal((Object)serializable, (HierarchicalStreamWriter)writer);
            }
        }

        static Object readFromXml(InputStream bufferedInput) throws IOException {
            XStream xstream = XmlIO.createXStream(false);
            xstream.addPermission(NoTypePermission.NONE);
            xstream.addPermission(NullPermission.NULL);
            xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
            xstream.allowTypesByWildcard(new String[]{"java.lang.*", "java.util.*", "java.util.concurrent.*"});
            xstream.allowTypesByWildcard(new String[]{PACKAGE_NAME + ".*"});
            try (InputStreamReader reader = new InputStreamReader(bufferedInput, XML_CHARSET_NAME);){
                Object object = xstream.fromXML((Reader)reader);
                return object;
            }
        }

        static void writeToJson(Serializable serializable, BufferedOutputStream bufferedOutput) throws IOException {
            XStream xstream = XmlIO.createXStream(true);
            try {
                xstream.toXML((Object)serializable, (OutputStream)bufferedOutput);
            }
            finally {
                bufferedOutput.close();
            }
        }

        private static XStream createXStream(boolean json) {
            XStream xstream = json ? new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()) : new XStream();
            for (Map.Entry<String, Class<?>> entry : XStreamAlias.getMap().entrySet()) {
                xstream.alias(entry.getKey(), entry.getValue());
            }
            MapConverter mapConverter = new MapConverter(xstream.getMapper()){

                public boolean canConvert(Class type) {
                    return true;
                }
            };
            xstream.registerLocalConverter(Counter.class, "requests", (Converter)mapConverter);
            xstream.registerLocalConverter(Counter.class, "rootCurrentContextsByThreadId", (Converter)mapConverter);
            return xstream;
        }
    }
}

