/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorServer;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.CounterRequestRumData;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.JRobin;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.web.html.HtmlCounterReport;
import net.bull.javamelody.internal.web.pdf.PdfAbstractTableReport;
import net.bull.javamelody.internal.web.pdf.PdfDocumentFactory;
import net.bull.javamelody.internal.web.pdf.PdfFonts;

public class PdfRequestAndGraphDetailReport
extends PdfAbstractTableReport {
    private final Collector collector;
    private final CollectorServer collectorServer;
    private final Range range;
    private final List<Counter> counters;
    private final String graphName;
    private final CounterRequest request;
    private final Map<String, CounterRequest> requestsById;
    private final PdfDocumentFactory pdfDocumentFactory;
    private final DecimalFormat systemErrorFormat = I18N.createPercentFormat();
    private final DecimalFormat nbExecutionsFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final Font boldFont = PdfFonts.BOLD.getFont();
    private final Font courierFont = FontFactory.getFont((String)"Courier", (float)5.5f, (int)0);

    PdfRequestAndGraphDetailReport(Collector collector, CollectorServer collectorServer, Range range, String graphName, PdfDocumentFactory pdfDocumentFactory, Document document) throws IOException {
        super(document);
        assert (collector != null);
        assert (range != null);
        assert (graphName != null);
        assert (pdfDocumentFactory != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.range = range;
        this.graphName = graphName;
        this.counters = collector.getRangeCounters(range);
        this.requestsById = this.mapAllRequestsById();
        this.request = this.requestsById.get(graphName);
        this.pdfDocumentFactory = pdfDocumentFactory;
    }

    private Map<String, CounterRequest> mapAllRequestsById() {
        HashMap<String, CounterRequest> result = new HashMap<String, CounterRequest>();
        for (Counter counter : this.counters) {
            for (CounterRequest aRequest : counter.getRequests()) {
                result.put(aRequest.getId(), aRequest);
            }
        }
        return result;
    }

    @Override
    void toPdf() throws DocumentException, IOException {
        if (this.request != null) {
            if (this.request.getRumData() != null && this.request.getRumData().getHits() != 0L) {
                this.writeRequestRumData();
            }
            this.writeHeader();
            this.writeRequests();
            this.addTableToDocument();
            if (JdbcWrapper.SINGLETON.getSqlCounter().isRequestIdFromThisCounter(this.request.getId()) && !this.request.getName().toLowerCase(Locale.ENGLISH).startsWith("alter ")) {
                this.writeSqlRequestExplainPlan();
            }
        }
        if (this.isGraphDisplayed()) {
            this.writeGraph();
        }
        if (this.request != null && this.request.getStackTrace() != null) {
            Paragraph paragraph = new Paragraph("\n", this.cellFont);
            paragraph.setIndentationLeft(20.0f);
            paragraph.setIndentationRight(20.0f);
            paragraph.add((Object)new Phrase("Stack-trace\n", this.boldFont));
            paragraph.add((Object)new Phrase(this.request.getStackTrace().replace("\t", "        "), this.cellFont));
            this.addToDocument((Element)paragraph);
        }
    }

    private void writeRequestRumData() throws DocumentException {
        CounterRequestRumData rumData = this.request.getRumData();
        DecimalFormat percentFormat = I18N.createPercentFormat();
        int networkTimeMean = rumData.getNetworkTimeMean();
        int serverMean = this.request.getMean();
        int domProcessingMean = rumData.getDomProcessingMean();
        int pageRenderingMean = rumData.getPageRenderingMean();
        int totalTime = networkTimeMean + serverMean + domProcessingMean + pageRenderingMean;
        double networkPercent = 100.0 * (double)networkTimeMean / (double)totalTime;
        double serverPercent = 100.0 * (double)serverMean / (double)totalTime;
        double domProcessingPercent = 100.0 * (double)domProcessingMean / (double)totalTime;
        double pageRenderingPercent = 100.0 * (double)pageRenderingMean / (double)totalTime;
        PdfPTable table = new PdfPTable(2);
        table.setHorizontalAlignment(0);
        table.setWidthPercentage(25.0f);
        table.getDefaultCell().setBorderWidth(0.0f);
        table.addCell(new Phrase(I18N.getString("Network"), this.cellFont));
        table.addCell(new Phrase(this.integerFormat.format(networkTimeMean) + " ms (" + percentFormat.format(networkPercent) + "%)", this.cellFont));
        table.addCell(new Phrase(I18N.getString("Server"), this.cellFont));
        table.addCell(new Phrase(this.integerFormat.format(serverMean) + " ms (" + percentFormat.format(serverPercent) + "%)", this.cellFont));
        table.addCell(new Phrase(I18N.getString("DOM_processing"), this.cellFont));
        table.addCell(new Phrase(this.integerFormat.format(domProcessingMean) + " ms (" + percentFormat.format(domProcessingPercent) + "%)", this.cellFont));
        table.addCell(new Phrase(I18N.getString("Page_rendering"), this.cellFont));
        table.addCell(new Phrase(this.integerFormat.format(pageRenderingMean) + " ms (" + percentFormat.format(pageRenderingPercent) + "%)", this.cellFont));
        this.addToDocument((Element)table);
        this.addToDocument((Element)new Phrase("\n", this.cellFont));
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[0] = 8;
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        boolean allChildHitsDisplayed;
        boolean hasChildren;
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfRequestAndGraphDetailReport.getString("Requete"));
        boolean bl = hasChildren = !this.request.getChildRequestsExecutionsByRequestId().isEmpty();
        if (hasChildren) {
            headers.add(PdfRequestAndGraphDetailReport.getString("Hits_par_requete"));
        }
        headers.add(PdfRequestAndGraphDetailReport.getString("Temps_moyen"));
        headers.add(PdfRequestAndGraphDetailReport.getString("Temps_max"));
        headers.add(PdfRequestAndGraphDetailReport.getString("Ecart_type"));
        headers.add(PdfRequestAndGraphDetailReport.getString("Temps_cpu_moyen"));
        if (this.isAllocatedKBytesDisplayed()) {
            headers.add(PdfRequestAndGraphDetailReport.getString("Ko_alloues_moyens"));
        }
        headers.add(PdfRequestAndGraphDetailReport.getString("erreur_systeme"));
        Counter parentCounter = this.getCounterByRequestId(this.request);
        boolean bl2 = allChildHitsDisplayed = parentCounter != null && parentCounter.getChildCounterName() != null && this.request.hasChildHits();
        if (allChildHitsDisplayed) {
            String childCounterName = parentCounter.getChildCounterName();
            headers.add(PdfRequestAndGraphDetailReport.getFormattedString("hits_fils_moyens", childCounterName));
            headers.add(PdfRequestAndGraphDetailReport.getFormattedString("temps_fils_moyen", childCounterName));
        }
        return headers;
    }

    private void writeRequests() throws IOException, DocumentException {
        Map<String, Long> childRequests = this.request.getChildRequestsExecutionsByRequestId();
        boolean hasChildren = !childRequests.isEmpty();
        Counter parentCounter = this.getCounterByRequestId(this.request);
        boolean allChildHitsDisplayed = parentCounter != null && parentCounter.getChildCounterName() != null && this.request.hasChildHits();
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setLeading(2.0f, 1.0f);
        defaultCell.setPaddingTop(0.0f);
        this.nextRow();
        this.writeRequest(this.request, -1.0f, allChildHitsDisplayed);
        if (hasChildren) {
            this.writeChildRequests(childRequests, allChildHitsDisplayed);
        }
    }

    private void writeChildRequests(Map<String, Long> childRequests, boolean allChildHitsDisplayed) throws IOException, DocumentException {
        for (Map.Entry<String, Long> entry : childRequests.entrySet()) {
            CounterRequest childRequest = this.requestsById.get(entry.getKey());
            if (childRequest == null) continue;
            this.nextRow();
            Long nbExecutions = entry.getValue();
            float executionsByRequest = (float)nbExecutions.longValue() / (float)this.request.getHits();
            this.writeRequest(childRequest, executionsByRequest, allChildHitsDisplayed);
        }
    }

    private void writeRequest(CounterRequest childRequest, float executionsByRequest, boolean allChildHitsDisplayed) throws IOException, DocumentException {
        Counter parentCounter;
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        Paragraph paragraph = new Paragraph(defaultCell.getLeading() + this.cellFont.getSize());
        if (executionsByRequest != -1.0f) {
            paragraph.setIndentationLeft(5.0f);
        }
        if ((parentCounter = this.getCounterByRequestId(childRequest)) != null && parentCounter.getIconName() != null) {
            paragraph.add((Object)new Chunk(this.getSmallImage(parentCounter.getIconName()), 0.0f, -1.0f));
        }
        paragraph.add((Object)new Phrase(childRequest.getName(), this.cellFont));
        PdfPCell requestCell = new PdfPCell();
        requestCell.addElement((Element)paragraph);
        requestCell.setGrayFill(defaultCell.getGrayFill());
        requestCell.setPaddingTop(defaultCell.getPaddingTop());
        this.addCell(requestCell);
        defaultCell.setHorizontalAlignment(2);
        if (executionsByRequest != -1.0f) {
            this.addCell(this.nbExecutionsFormat.format(executionsByRequest));
        } else {
            boolean hasChildren;
            boolean bl = hasChildren = !this.request.getChildRequestsExecutionsByRequestId().isEmpty();
            if (hasChildren) {
                this.addCell("");
            }
        }
        this.writeRequestValues(childRequest, allChildHitsDisplayed);
    }

    private void writeRequestValues(CounterRequest aRequest, boolean allChildHitsDisplayed) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(2);
        this.addCell(this.integerFormat.format(aRequest.getMean()));
        this.addCell(this.integerFormat.format(aRequest.getMaximum()));
        this.addCell(this.integerFormat.format(aRequest.getStandardDeviation()));
        if (aRequest.getCpuTimeMean() >= 0) {
            this.addCell(this.integerFormat.format(aRequest.getCpuTimeMean()));
        } else {
            this.addCell("");
        }
        if (this.isAllocatedKBytesDisplayed()) {
            if (aRequest.getAllocatedKBytesMean() >= 0) {
                this.addCell(this.integerFormat.format(aRequest.getAllocatedKBytesMean()));
            } else {
                this.addCell("");
            }
        }
        this.addCell(this.systemErrorFormat.format(aRequest.getSystemErrorPercentage()));
        if (allChildHitsDisplayed) {
            boolean childHitsDisplayed = aRequest.hasChildHits();
            if (childHitsDisplayed) {
                this.addCell(this.integerFormat.format(aRequest.getChildHitsMean()));
            } else {
                this.addCell("");
            }
            if (childHitsDisplayed) {
                this.addCell(this.integerFormat.format(aRequest.getChildDurationsMean()));
            } else {
                this.addCell("");
            }
        }
    }

    private boolean isAllocatedKBytesDisplayed() {
        return this.request.getAllocatedKBytesMean() >= 0;
    }

    private void writeGraph() throws IOException, DocumentException {
        JRobin jrobin = this.collector.getJRobin(this.graphName);
        if (jrobin != null) {
            byte[] img = jrobin.graph(this.range, 960, 400);
            Image image = Image.getInstance((byte[])img);
            image.scalePercent(50.0f);
            PdfPTable table = new PdfPTable(1);
            table.setHorizontalAlignment(1);
            table.setWidthPercentage(100.0f);
            table.getDefaultCell().setBorder(0);
            table.addCell("\n");
            table.addCell(image);
            table.getDefaultCell().setHorizontalAlignment(2);
            table.addCell(new Phrase(PdfRequestAndGraphDetailReport.getString("graph_units"), this.cellFont));
            this.addToDocument((Element)table);
        } else {
            this.addToDocument((Element)new Phrase("\n", this.cellFont));
        }
    }

    private void writeSqlRequestExplainPlan() throws DocumentException {
        try {
            String explainPlan = this.collectorServer == null ? DatabaseInformations.explainPlanFor(this.request.getName()) : this.collectorServer.collectSqlRequestExplainPlan(this.collector.getApplication(), this.request.getName());
            if (explainPlan != null) {
                Paragraph paragraph = new Paragraph("", this.cellFont);
                paragraph.add((Object)new Phrase('\n' + PdfRequestAndGraphDetailReport.getString("Plan_d_execution") + '\n', this.boldFont));
                paragraph.add((Object)new Phrase(explainPlan, this.courierFont));
                this.addToDocument((Element)paragraph);
            }
        }
        catch (Exception e) {
            Paragraph paragraph = new Paragraph("", this.cellFont);
            paragraph.add((Object)new Phrase('\n' + PdfRequestAndGraphDetailReport.getString("Plan_d_execution") + '\n', this.boldFont));
            paragraph.add((Object)new Phrase(e.toString(), this.cellFont));
            this.addToDocument((Element)paragraph);
        }
    }

    private Counter getCounterByRequestId(CounterRequest aRequest) {
        String myRequestId = aRequest.getId();
        for (Counter counter : this.counters) {
            if (!counter.isRequestIdFromThisCounter(myRequestId)) continue;
            return counter;
        }
        return null;
    }

    private boolean isGraphDisplayed() throws IOException {
        return this.request == null || this.getCounterByRequestId(this.request) != null && HtmlCounterReport.isRequestGraphDisplayed(this.getCounterByRequestId(this.request)) && this.collector.getJRobin(this.request.getId()) != null;
    }

    private Image getSmallImage(String resourceFileName) throws DocumentException, IOException {
        return this.pdfDocumentFactory.getSmallImage(resourceFileName);
    }
}

