/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.Thumbnailator;
import net.coobird.thumbnailator.filters.Canvas;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.filters.Pipeline;
import net.coobird.thumbnailator.filters.Rotation;
import net.coobird.thumbnailator.filters.Watermark;
import net.coobird.thumbnailator.geometry.AbsoluteSize;
import net.coobird.thumbnailator.geometry.Coordinate;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import net.coobird.thumbnailator.geometry.Region;
import net.coobird.thumbnailator.geometry.Size;
import net.coobird.thumbnailator.name.Rename;
import net.coobird.thumbnailator.resizers.BicubicResizer;
import net.coobird.thumbnailator.resizers.BilinearResizer;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import net.coobird.thumbnailator.resizers.FixedResizerFactory;
import net.coobird.thumbnailator.resizers.ProgressiveBilinearResizer;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.resizers.ResizerFactory;
import net.coobird.thumbnailator.resizers.configurations.AlphaInterpolation;
import net.coobird.thumbnailator.resizers.configurations.Antialiasing;
import net.coobird.thumbnailator.resizers.configurations.Dithering;
import net.coobird.thumbnailator.resizers.configurations.Rendering;
import net.coobird.thumbnailator.resizers.configurations.ScalingMode;
import net.coobird.thumbnailator.tasks.SourceSinkThumbnailTask;
import net.coobird.thumbnailator.tasks.io.BufferedImageSink;
import net.coobird.thumbnailator.tasks.io.BufferedImageSource;
import net.coobird.thumbnailator.tasks.io.FileImageSink;
import net.coobird.thumbnailator.tasks.io.FileImageSource;
import net.coobird.thumbnailator.tasks.io.ImageSource;
import net.coobird.thumbnailator.tasks.io.InputStreamImageSource;
import net.coobird.thumbnailator.tasks.io.OutputStreamImageSink;
import net.coobird.thumbnailator.tasks.io.URLImageSource;
import net.coobird.thumbnailator.util.ThumbnailatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Thumbnails {
    private Thumbnails() {
    }

    private static void validateDimensions(int n, int n2) {
        if (n <= 0 && n2 <= 0) {
            throw new IllegalArgumentException("Destination image dimensions must not be less than 0 pixels.");
        }
        if (n <= 0 || n2 <= 0) {
            String string = n == 0 ? "width" : "height";
            throw new IllegalArgumentException("Destination image " + string + " must not be " + "less than or equal to 0 pixels.");
        }
    }

    private static void checkForNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    private static void checkForEmpty(Object[] objectArray, String string) {
        if (objectArray.length == 0) {
            throw new IllegalArgumentException(string);
        }
    }

    private static void checkForEmpty(Iterable<?> iterable, String string) {
        if (!iterable.iterator().hasNext()) {
            throw new IllegalArgumentException(string);
        }
    }

    public static Builder<File> of(String ... stringArray) {
        Thumbnails.checkForNull(stringArray, "Cannot specify null for input files.");
        Thumbnails.checkForEmpty(stringArray, "Cannot specify an empty array for input files.");
        return Builder.ofStrings(Arrays.asList(stringArray));
    }

    public static Builder<File> of(File ... fileArray) {
        Thumbnails.checkForNull(fileArray, "Cannot specify null for input files.");
        Thumbnails.checkForEmpty(fileArray, "Cannot specify an empty array for input files.");
        return Builder.ofFiles(Arrays.asList(fileArray));
    }

    public static Builder<URL> of(URL ... uRLArray) {
        Thumbnails.checkForNull(uRLArray, "Cannot specify null for input URLs.");
        Thumbnails.checkForEmpty(uRLArray, "Cannot specify an empty array for input URLs.");
        return Builder.ofUrls(Arrays.asList(uRLArray));
    }

    public static Builder<? extends InputStream> of(InputStream ... inputStreamArray) {
        Thumbnails.checkForNull(inputStreamArray, "Cannot specify null for InputStreams.");
        Thumbnails.checkForEmpty(inputStreamArray, "Cannot specify an empty array for InputStreams.");
        return Builder.ofInputStreams(Arrays.asList(inputStreamArray));
    }

    public static Builder<BufferedImage> of(BufferedImage ... bufferedImageArray) {
        Thumbnails.checkForNull(bufferedImageArray, "Cannot specify null for images.");
        Thumbnails.checkForEmpty(bufferedImageArray, "Cannot specify an empty array for images.");
        return Builder.ofBufferedImages(Arrays.asList(bufferedImageArray));
    }

    public static Builder<File> fromFilenames(Iterable<String> iterable) {
        Thumbnails.checkForNull(iterable, "Cannot specify null for input files.");
        Thumbnails.checkForEmpty(iterable, "Cannot specify an empty collection for input files.");
        return Builder.ofStrings(iterable);
    }

    public static Builder<File> fromFiles(Iterable<File> iterable) {
        Thumbnails.checkForNull(iterable, "Cannot specify null for input files.");
        Thumbnails.checkForEmpty(iterable, "Cannot specify an empty collection for input files.");
        return Builder.ofFiles(iterable);
    }

    public static Builder<URL> fromURLs(Iterable<URL> iterable) {
        Thumbnails.checkForNull(iterable, "Cannot specify null for input URLs.");
        Thumbnails.checkForEmpty(iterable, "Cannot specify an empty collection for input URLs.");
        return Builder.ofUrls(iterable);
    }

    public static Builder<InputStream> fromInputStreams(Iterable<? extends InputStream> iterable) {
        Thumbnails.checkForNull(iterable, "Cannot specify null for InputStreams.");
        Thumbnails.checkForEmpty(iterable, "Cannot specify an empty collection for InputStreams.");
        return Builder.ofInputStreams(iterable);
    }

    public static Builder<BufferedImage> fromImages(Iterable<BufferedImage> iterable) {
        Thumbnails.checkForNull(iterable, "Cannot specify null for images.");
        Thumbnails.checkForEmpty(iterable, "Cannot specify an empty collection for images.");
        return Builder.ofBufferedImages(iterable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private final Iterable<ImageSource<T>> sources;
        private final Map<Properties, Status> statusMap = new HashMap<Properties, Status>();
        private static int IMAGE_TYPE_UNSPECIFIED = -1;
        private static final int DIMENSION_NOT_SPECIFIED = -1;
        private int width;
        private int height;
        private double scaleWidth;
        private double scaleHeight;
        private Region sourceRegion;
        private int imageType;
        private boolean keepAspectRatio;
        private String outputFormat;
        private String outputFormatType;
        private float outputQuality;
        private ScalingMode scalingMode;
        private AlphaInterpolation alphaInterpolation;
        private Dithering dithering;
        private Antialiasing antialiasing;
        private Rendering rendering;
        private ResizerFactory resizerFactory;
        private boolean allowOverwrite;
        private boolean fitWithinDimenions;
        private boolean useExifOrientation;
        private Position croppingPosition;
        private Pipeline filterPipeline;

        private Builder(Iterable<ImageSource<T>> iterable) {
            this.statusMap.put(Properties.SIZE, Status.NOT_READY);
            this.statusMap.put(Properties.WIDTH, Status.OPTIONAL);
            this.statusMap.put(Properties.HEIGHT, Status.OPTIONAL);
            this.statusMap.put(Properties.SCALE, Status.NOT_READY);
            this.statusMap.put(Properties.SOURCE_REGION, Status.OPTIONAL);
            this.statusMap.put(Properties.IMAGE_TYPE, Status.OPTIONAL);
            this.statusMap.put(Properties.SCALING_MODE, Status.OPTIONAL);
            this.statusMap.put(Properties.ALPHA_INTERPOLATION, Status.OPTIONAL);
            this.statusMap.put(Properties.ANTIALIASING, Status.OPTIONAL);
            this.statusMap.put(Properties.DITHERING, Status.OPTIONAL);
            this.statusMap.put(Properties.RENDERING, Status.OPTIONAL);
            this.statusMap.put(Properties.KEEP_ASPECT_RATIO, Status.OPTIONAL);
            this.statusMap.put(Properties.OUTPUT_FORMAT, Status.OPTIONAL);
            this.statusMap.put(Properties.OUTPUT_FORMAT_TYPE, Status.OPTIONAL);
            this.statusMap.put(Properties.OUTPUT_QUALITY, Status.OPTIONAL);
            this.statusMap.put(Properties.RESIZER, Status.OPTIONAL);
            this.statusMap.put(Properties.RESIZER_FACTORY, Status.OPTIONAL);
            this.statusMap.put(Properties.ALLOW_OVERWRITE, Status.OPTIONAL);
            this.statusMap.put(Properties.CROP, Status.OPTIONAL);
            this.statusMap.put(Properties.USE_EXIF_ORIENTATION, Status.OPTIONAL);
            this.width = -1;
            this.height = -1;
            this.scaleWidth = Double.NaN;
            this.scaleHeight = Double.NaN;
            this.imageType = IMAGE_TYPE_UNSPECIFIED;
            this.keepAspectRatio = true;
            this.outputFormat = "\u0000";
            this.outputFormatType = ThumbnailParameter.DEFAULT_FORMAT_TYPE;
            this.outputQuality = Float.NaN;
            this.scalingMode = ScalingMode.PROGRESSIVE_BILINEAR;
            this.alphaInterpolation = AlphaInterpolation.DEFAULT;
            this.dithering = Dithering.DEFAULT;
            this.antialiasing = Antialiasing.DEFAULT;
            this.rendering = Rendering.DEFAULT;
            this.resizerFactory = DefaultResizerFactory.getInstance();
            this.allowOverwrite = true;
            this.fitWithinDimenions = true;
            this.useExifOrientation = true;
            this.croppingPosition = null;
            this.filterPipeline = new Pipeline();
            this.sources = iterable;
            this.statusMap.put(Properties.OUTPUT_FORMAT, Status.OPTIONAL);
        }

        private static Builder<File> ofStrings(Iterable<String> iterable) {
            StringImageSourceIterator stringImageSourceIterator = new StringImageSourceIterator(iterable);
            return new Builder<File>(stringImageSourceIterator);
        }

        private static Builder<File> ofFiles(Iterable<File> iterable) {
            FileImageSourceIterator fileImageSourceIterator = new FileImageSourceIterator(iterable);
            return new Builder<File>(fileImageSourceIterator);
        }

        private static Builder<URL> ofUrls(Iterable<URL> iterable) {
            URLImageSourceIterator uRLImageSourceIterator = new URLImageSourceIterator(iterable);
            return new Builder<URL>(uRLImageSourceIterator);
        }

        private static Builder<InputStream> ofInputStreams(Iterable<? extends InputStream> iterable) {
            InputStreamImageSourceIterator inputStreamImageSourceIterator = new InputStreamImageSourceIterator(iterable);
            return new Builder<InputStream>(inputStreamImageSourceIterator);
        }

        private static Builder<BufferedImage> ofBufferedImages(Iterable<BufferedImage> iterable) {
            BufferedImageImageSourceIterator bufferedImageImageSourceIterator = new BufferedImageImageSourceIterator(iterable);
            return new Builder<BufferedImage>(bufferedImageImageSourceIterator);
        }

        private void updateStatus(Properties properties, Status status) {
            if (this.statusMap.get(properties) == Status.ALREADY_SET) {
                throw new IllegalStateException(properties.getName() + " is already set.");
            }
            if (status != Status.CANNOT_SET && this.statusMap.get(properties) == Status.CANNOT_SET) {
                throw new IllegalStateException(properties.getName() + " cannot be set.");
            }
            this.statusMap.put(properties, status);
        }

        public Builder<T> size(int n, int n2) {
            this.updateStatus(Properties.SIZE, Status.ALREADY_SET);
            this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            Thumbnails.validateDimensions(n, n2);
            this.width = n;
            this.height = n2;
            return this;
        }

        public Builder<T> width(int n) {
            if (this.statusMap.get(Properties.SIZE) != Status.CANNOT_SET) {
                this.updateStatus(Properties.SIZE, Status.CANNOT_SET);
            }
            if (this.statusMap.get(Properties.SCALE) != Status.CANNOT_SET) {
                this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            }
            this.updateStatus(Properties.WIDTH, Status.ALREADY_SET);
            Thumbnails.validateDimensions(n, Integer.MAX_VALUE);
            this.width = n;
            return this;
        }

        public Builder<T> height(int n) {
            if (this.statusMap.get(Properties.SIZE) != Status.CANNOT_SET) {
                this.updateStatus(Properties.SIZE, Status.CANNOT_SET);
            }
            if (this.statusMap.get(Properties.SCALE) != Status.CANNOT_SET) {
                this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            }
            this.updateStatus(Properties.HEIGHT, Status.ALREADY_SET);
            Thumbnails.validateDimensions(Integer.MAX_VALUE, n);
            this.height = n;
            return this;
        }

        public Builder<T> forceSize(int n, int n2) {
            this.updateStatus(Properties.SIZE, Status.ALREADY_SET);
            this.updateStatus(Properties.KEEP_ASPECT_RATIO, Status.ALREADY_SET);
            this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            Thumbnails.validateDimensions(n, n2);
            this.width = n;
            this.height = n2;
            this.keepAspectRatio = false;
            return this;
        }

        public Builder<T> scale(double d) {
            return this.scale(d, d);
        }

        public Builder<T> scale(double d, double d2) {
            this.updateStatus(Properties.SCALE, Status.ALREADY_SET);
            this.updateStatus(Properties.SIZE, Status.CANNOT_SET);
            this.updateStatus(Properties.KEEP_ASPECT_RATIO, Status.CANNOT_SET);
            if (d <= 0.0 || d2 <= 0.0) {
                throw new IllegalArgumentException("The scaling factor is equal to or less than 0.");
            }
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                throw new IllegalArgumentException("The scaling factor is not a number.");
            }
            if (Double.isInfinite(d) || Double.isInfinite(d2)) {
                throw new IllegalArgumentException("The scaling factor cannot be infinity.");
            }
            this.scaleWidth = d;
            this.scaleHeight = d2;
            return this;
        }

        public Builder<T> sourceRegion(Region region) {
            if (region == null) {
                throw new NullPointerException("Region cannot be null.");
            }
            this.updateStatus(Properties.SOURCE_REGION, Status.ALREADY_SET);
            this.sourceRegion = region;
            return this;
        }

        public Builder<T> sourceRegion(Position position, Size size) {
            if (position == null) {
                throw new NullPointerException("Position cannot be null.");
            }
            if (size == null) {
                throw new NullPointerException("Size cannot be null.");
            }
            return this.sourceRegion(new Region(position, size));
        }

        public Builder<T> sourceRegion(int n, int n2, int n3, int n4) {
            if (n3 <= 0 || n4 <= 0) {
                throw new IllegalArgumentException("Width and height must be greater than 0.");
            }
            return this.sourceRegion(new Coordinate(n, n2), new AbsoluteSize(n3, n4));
        }

        public Builder<T> sourceRegion(Position position, int n, int n2) {
            if (position == null) {
                throw new NullPointerException("Position cannot be null.");
            }
            if (n <= 0 || n2 <= 0) {
                throw new IllegalArgumentException("Width and height must be greater than 0.");
            }
            return this.sourceRegion(position, new AbsoluteSize(n, n2));
        }

        public Builder<T> sourceRegion(Rectangle rectangle) {
            if (rectangle == null) {
                throw new NullPointerException("Region cannot be null.");
            }
            return this.sourceRegion(new Coordinate(rectangle.x, rectangle.y), new AbsoluteSize(rectangle.getSize()));
        }

        public Builder<T> crop(Position position) {
            Thumbnails.checkForNull(position, "Position cannot be null.");
            this.updateStatus(Properties.CROP, Status.ALREADY_SET);
            this.updateStatus(Properties.SCALE, Status.CANNOT_SET);
            this.croppingPosition = position;
            this.fitWithinDimenions = false;
            return this;
        }

        public Builder<T> allowOverwrite(boolean bl) {
            this.updateStatus(Properties.ALLOW_OVERWRITE, Status.ALREADY_SET);
            this.allowOverwrite = bl;
            return this;
        }

        public Builder<T> imageType(int n) {
            this.updateStatus(Properties.IMAGE_TYPE, Status.ALREADY_SET);
            this.imageType = n;
            return this;
        }

        public Builder<T> scalingMode(ScalingMode scalingMode) {
            Thumbnails.checkForNull((Object)scalingMode, "Scaling mode is null.");
            this.updateStatus(Properties.SCALING_MODE, Status.ALREADY_SET);
            this.updateStatus(Properties.RESIZER, Status.CANNOT_SET);
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.scalingMode = scalingMode;
            return this;
        }

        public Builder<T> resizer(Resizer resizer) {
            Thumbnails.checkForNull(resizer, "Resizer is null.");
            this.updateStatus(Properties.RESIZER, Status.ALREADY_SET);
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.SCALING_MODE, Status.CANNOT_SET);
            this.resizerFactory = new FixedResizerFactory(resizer);
            return this;
        }

        public Builder<T> resizerFactory(ResizerFactory resizerFactory) {
            Thumbnails.checkForNull(resizerFactory, "ResizerFactory is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.ALREADY_SET);
            this.updateStatus(Properties.RESIZER, Status.CANNOT_SET);
            this.updateStatus(Properties.SCALING_MODE, Status.CANNOT_SET);
            this.updateStatus(Properties.ALPHA_INTERPOLATION, Status.CANNOT_SET);
            this.updateStatus(Properties.DITHERING, Status.CANNOT_SET);
            this.updateStatus(Properties.ANTIALIASING, Status.CANNOT_SET);
            this.updateStatus(Properties.RENDERING, Status.CANNOT_SET);
            this.resizerFactory = resizerFactory;
            return this;
        }

        public Builder<T> alphaInterpolation(AlphaInterpolation alphaInterpolation) {
            Thumbnails.checkForNull(alphaInterpolation, "Alpha interpolation is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.ALPHA_INTERPOLATION, Status.ALREADY_SET);
            this.alphaInterpolation = alphaInterpolation;
            return this;
        }

        public Builder<T> dithering(Dithering dithering) {
            Thumbnails.checkForNull(dithering, "Dithering is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.DITHERING, Status.ALREADY_SET);
            this.dithering = dithering;
            return this;
        }

        public Builder<T> antialiasing(Antialiasing antialiasing) {
            Thumbnails.checkForNull(antialiasing, "Antialiasing is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.ANTIALIASING, Status.ALREADY_SET);
            this.antialiasing = antialiasing;
            return this;
        }

        public Builder<T> rendering(Rendering rendering) {
            Thumbnails.checkForNull(rendering, "Rendering is null.");
            this.updateStatus(Properties.RESIZER_FACTORY, Status.CANNOT_SET);
            this.updateStatus(Properties.RENDERING, Status.ALREADY_SET);
            this.rendering = rendering;
            return this;
        }

        public Builder<T> keepAspectRatio(boolean bl) {
            if (this.statusMap.get(Properties.SCALE) == Status.ALREADY_SET) {
                throw new IllegalStateException("Cannot specify whether to keep the aspect ratio if the scaling factor has already been specified.");
            }
            if (this.statusMap.get(Properties.SIZE) == Status.NOT_READY) {
                throw new IllegalStateException("Cannot specify whether to keep the aspect ratio unless the size parameter has already been specified.");
            }
            if (!(this.statusMap.get(Properties.WIDTH) != Status.ALREADY_SET && this.statusMap.get(Properties.HEIGHT) != Status.ALREADY_SET || bl)) {
                throw new IllegalStateException("The aspect ratio must be preserved when the width and/or height parameter has already been specified.");
            }
            this.updateStatus(Properties.KEEP_ASPECT_RATIO, Status.ALREADY_SET);
            this.keepAspectRatio = bl;
            return this;
        }

        public Builder<T> outputQuality(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException("The quality setting must be in the range 0.0f and 1.0f, inclusive.");
            }
            this.updateStatus(Properties.OUTPUT_QUALITY, Status.ALREADY_SET);
            this.outputQuality = f;
            return this;
        }

        public Builder<T> outputQuality(double d) {
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("The quality setting must be in the range 0.0d and 1.0d, inclusive.");
            }
            this.updateStatus(Properties.OUTPUT_QUALITY, Status.ALREADY_SET);
            this.outputQuality = (float)d;
            if (this.outputQuality < 0.0f) {
                this.outputQuality = 0.0f;
            } else if (this.outputQuality > 1.0f) {
                this.outputQuality = 1.0f;
            }
            return this;
        }

        public Builder<T> outputFormat(String string) {
            if (!ThumbnailatorUtils.isSupportedOutputFormat(string)) {
                throw new IllegalArgumentException("Specified format is not supported: " + string);
            }
            this.updateStatus(Properties.OUTPUT_FORMAT, Status.ALREADY_SET);
            this.outputFormat = string;
            return this;
        }

        public Builder<T> useOriginalFormat() {
            this.updateStatus(Properties.OUTPUT_FORMAT, Status.ALREADY_SET);
            this.outputFormat = ThumbnailParameter.ORIGINAL_FORMAT;
            return this;
        }

        public Builder<T> useExifOrientation(boolean bl) {
            this.updateStatus(Properties.USE_EXIF_ORIENTATION, Status.ALREADY_SET);
            this.useExifOrientation = bl;
            return this;
        }

        public Builder<T> determineOutputFormat() {
            this.updateStatus(Properties.OUTPUT_FORMAT, Status.ALREADY_SET);
            this.outputFormat = "\u0000";
            return this;
        }

        private boolean isOutputFormatNotSet() {
            return this.outputFormat == null || "\u0000".equals(this.outputFormat);
        }

        public Builder<T> outputFormatType(String string) {
            if (string != ThumbnailParameter.DEFAULT_FORMAT_TYPE && this.isOutputFormatNotSet()) {
                throw new IllegalArgumentException("Cannot set the format type if a specific output format has not been specified.");
            }
            if (!ThumbnailatorUtils.isSupportedOutputFormatType(this.outputFormat, string)) {
                throw new IllegalArgumentException("Specified format type (" + string + ") is not " + " supported for the format: " + this.outputFormat);
            }
            this.updateStatus(Properties.OUTPUT_FORMAT_TYPE, Status.ALREADY_SET);
            if (!this.statusMap.containsKey(Properties.OUTPUT_FORMAT)) {
                this.updateStatus(Properties.OUTPUT_FORMAT, Status.CANNOT_SET);
            }
            this.outputFormatType = string;
            return this;
        }

        public Builder<T> watermark(Watermark watermark) {
            if (watermark == null) {
                throw new NullPointerException("Watermark is null.");
            }
            this.filterPipeline.add(watermark);
            return this;
        }

        public Builder<T> watermark(BufferedImage bufferedImage) {
            return this.watermark(Positions.CENTER, bufferedImage, 0.5f);
        }

        public Builder<T> watermark(BufferedImage bufferedImage, float f) {
            return this.watermark(Positions.CENTER, bufferedImage, f);
        }

        public Builder<T> watermark(Position position, BufferedImage bufferedImage, float f) {
            this.filterPipeline.add(new Watermark(position, bufferedImage, f));
            return this;
        }

        public Builder<T> rotate(double d) {
            this.filterPipeline.add(Rotation.newRotator(d));
            return this;
        }

        public Builder<T> addFilter(ImageFilter imageFilter) {
            if (imageFilter == null) {
                throw new NullPointerException("Filter is null.");
            }
            this.filterPipeline.add(imageFilter);
            return this;
        }

        public Builder<T> addFilters(List<ImageFilter> list) {
            if (list == null) {
                throw new NullPointerException("Filters is null.");
            }
            this.filterPipeline.addAll(list);
            return this;
        }

        private void checkReadiness() {
            for (Map.Entry<Properties, Status> entry : this.statusMap.entrySet()) {
                if (entry.getValue() != Status.NOT_READY) continue;
                throw new IllegalStateException(entry.getKey().getName() + " is not set.");
            }
        }

        private Resizer makeResizer(ScalingMode scalingMode) {
            HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
            hashMap.put(RenderingHints.KEY_ALPHA_INTERPOLATION, this.alphaInterpolation.getValue());
            hashMap.put(RenderingHints.KEY_DITHERING, this.dithering.getValue());
            hashMap.put(RenderingHints.KEY_ANTIALIASING, this.antialiasing.getValue());
            hashMap.put(RenderingHints.KEY_RENDERING, this.rendering.getValue());
            if (scalingMode == ScalingMode.BILINEAR) {
                return new BilinearResizer(hashMap);
            }
            if (scalingMode == ScalingMode.BICUBIC) {
                return new BicubicResizer(hashMap);
            }
            if (scalingMode == ScalingMode.PROGRESSIVE_BILINEAR) {
                return new ProgressiveBilinearResizer(hashMap);
            }
            return new ProgressiveBilinearResizer(hashMap);
        }

        private void prepareResizerFactory() {
            if (this.statusMap.get(Properties.SCALING_MODE) == Status.ALREADY_SET) {
                this.resizerFactory = new FixedResizerFactory(this.makeResizer(this.scalingMode));
            }
        }

        private ThumbnailParameter makeParam() {
            this.prepareResizerFactory();
            int n = this.imageType;
            if (this.imageType == IMAGE_TYPE_UNSPECIFIED) {
                n = -1;
            }
            if (this.croppingPosition != null) {
                this.filterPipeline.addFirst(new Canvas(this.width, this.height, this.croppingPosition));
            }
            if (Double.isNaN(this.scaleWidth)) {
                if (this.width == -1 && this.height == -1) {
                    throw new IllegalStateException("The width or height must be specified. If this exception is thrown, it is due to a bug in the Thumbnailator library.");
                }
                if (this.width == -1) {
                    this.width = Integer.MAX_VALUE;
                }
                if (this.height == -1) {
                    this.height = Integer.MAX_VALUE;
                }
                return new ThumbnailParameter(new Dimension(this.width, this.height), this.sourceRegion, this.keepAspectRatio, this.outputFormat, this.outputFormatType, this.outputQuality, n, this.filterPipeline.getFilters(), this.resizerFactory, this.fitWithinDimenions, this.useExifOrientation);
            }
            return new ThumbnailParameter(this.scaleWidth, this.scaleHeight, this.sourceRegion, this.keepAspectRatio, this.outputFormat, this.outputFormatType, this.outputQuality, n, this.filterPipeline.getFilters(), this.resizerFactory, this.fitWithinDimenions, this.useExifOrientation);
        }

        public Iterable<BufferedImage> iterableBufferedImages() {
            this.checkReadiness();
            return new BufferedImageIterable();
        }

        public List<BufferedImage> asBufferedImages() throws IOException {
            this.checkReadiness();
            ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
            for (ImageSource<T> imageSource : this.sources) {
                BufferedImageSink bufferedImageSink = new BufferedImageSink();
                Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, BufferedImage>(this.makeParam(), imageSource, bufferedImageSink));
                arrayList.add(bufferedImageSink.getSink());
            }
            return arrayList;
        }

        public BufferedImage asBufferedImage() throws IOException {
            this.checkReadiness();
            Iterator<ImageSource<T>> iterator = this.sources.iterator();
            ImageSource<T> imageSource = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("Cannot create one thumbnail from multiple original images.");
            }
            BufferedImageSink bufferedImageSink = new BufferedImageSink();
            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, BufferedImage>(this.makeParam(), imageSource, bufferedImageSink));
            return bufferedImageSink.getSink();
        }

        public List<File> asFiles(Iterable<File> iterable) throws IOException {
            this.checkReadiness();
            if (iterable == null) {
                throw new NullPointerException("File name iterable is null.");
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            Iterator<File> iterator = iterable.iterator();
            for (ImageSource<T> imageSource : this.sources) {
                if (!iterator.hasNext()) {
                    throw new IndexOutOfBoundsException("Not enough file names provided by iterator.");
                }
                ThumbnailParameter thumbnailParameter = this.makeParam();
                FileImageSink fileImageSink = new FileImageSink(iterator.next(), this.allowOverwrite);
                try {
                    Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, File>(thumbnailParameter, imageSource, fileImageSink));
                    arrayList.add(fileImageSink.getSink());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return arrayList;
        }

        public void toFiles(Iterable<File> iterable) throws IOException {
            this.asFiles(iterable);
        }

        public List<File> asFiles(Rename rename) throws IOException {
            this.checkReadiness();
            if (rename == null) {
                throw new NullPointerException("Rename is null.");
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            for (ImageSource<T> imageSource : this.sources) {
                if (!(imageSource instanceof FileImageSource)) {
                    throw new IllegalStateException("Cannot create thumbnails to files if original images are not from files.");
                }
                ThumbnailParameter thumbnailParameter = this.makeParam();
                File file = ((FileImageSource)imageSource).getSource();
                File file2 = new File(file.getParent(), rename.apply(file.getName(), thumbnailParameter));
                FileImageSink fileImageSink = new FileImageSink(file2, this.allowOverwrite);
                try {
                    Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, File>(thumbnailParameter, imageSource, fileImageSink));
                    arrayList.add(fileImageSink.getSink());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return arrayList;
        }

        public void toFiles(Rename rename) throws IOException {
            this.asFiles(rename);
        }

        public void toFile(File file) throws IOException {
            this.checkReadiness();
            Iterator<ImageSource<T>> iterator = this.sources.iterator();
            ImageSource<T> imageSource = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("Cannot output multiple thumbnails to one file.");
            }
            FileImageSink fileImageSink = new FileImageSink(file, this.allowOverwrite);
            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, File>(this.makeParam(), imageSource, fileImageSink));
        }

        public void toFile(String string) throws IOException {
            this.checkReadiness();
            Iterator<ImageSource<T>> iterator = this.sources.iterator();
            ImageSource<T> imageSource = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("Cannot output multiple thumbnails to one file.");
            }
            FileImageSink fileImageSink = new FileImageSink(string, this.allowOverwrite);
            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, File>(this.makeParam(), imageSource, fileImageSink));
        }

        public void toOutputStream(OutputStream outputStream) throws IOException {
            this.checkReadiness();
            Iterator<ImageSource<T>> iterator = this.sources.iterator();
            ImageSource<T> imageSource = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("Cannot output multiple thumbnails to a single OutputStream.");
            }
            if (imageSource instanceof BufferedImageSource && this.isOutputFormatNotSet()) {
                throw new IllegalStateException("Output format not specified.");
            }
            OutputStreamImageSink outputStreamImageSink = new OutputStreamImageSink(outputStream);
            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, OutputStream>(this.makeParam(), imageSource, outputStreamImageSink));
        }

        public void toOutputStreams(Iterable<? extends OutputStream> iterable) throws IOException {
            this.checkReadiness();
            if (iterable == null) {
                throw new NullPointerException("OutputStream iterable is null.");
            }
            Iterator<? extends OutputStream> iterator = iterable.iterator();
            for (ImageSource<T> imageSource : this.sources) {
                if (imageSource instanceof BufferedImageSource && this.isOutputFormatNotSet()) {
                    throw new IllegalStateException("Output format not specified.");
                }
                if (!iterator.hasNext()) {
                    throw new IndexOutOfBoundsException("Not enough file names provided by iterator.");
                }
                OutputStreamImageSink outputStreamImageSink = new OutputStreamImageSink(iterator.next());
                Thumbnailator.createThumbnail(new SourceSinkThumbnailTask<T, OutputStream>(this.makeParam(), imageSource, outputStreamImageSink));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Properties implements Property
        {
            SIZE("size"),
            WIDTH("width"),
            HEIGHT("height"),
            SCALE("scale"),
            IMAGE_TYPE("imageType"),
            SCALING_MODE("scalingMode"),
            ALPHA_INTERPOLATION("alphaInterpolation"),
            ANTIALIASING("antialiasing"),
            DITHERING("dithering"),
            RENDERING("rendering"),
            KEEP_ASPECT_RATIO("keepAspectRatio"),
            OUTPUT_FORMAT("outputFormat"),
            OUTPUT_FORMAT_TYPE("outputFormatType"),
            OUTPUT_QUALITY("outputQuality"),
            RESIZER("resizer"),
            SOURCE_REGION("sourceRegion"),
            RESIZER_FACTORY("resizerFactory"),
            ALLOW_OVERWRITE("allowOverwrite"),
            CROP("crop"),
            USE_EXIF_ORIENTATION("useExifOrientation");

            private final String name;

            private Properties(String string2) {
                this.name = string2;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        private static interface Property {
            public String getName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Status {
            OPTIONAL,
            READY,
            NOT_READY,
            ALREADY_SET,
            CANNOT_SET;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class BufferedImageIterable
        implements Iterable<BufferedImage> {
            private BufferedImageIterable() {
            }

            @Override
            public Iterator<BufferedImage> iterator() {
                return new Iterator<BufferedImage>(){
                    Iterator<ImageSource<T>> sourceIter;
                    {
                        this.sourceIter = Builder.this.sources.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.sourceIter.hasNext();
                    }

                    @Override
                    public BufferedImage next() {
                        ImageSource imageSource = this.sourceIter.next();
                        BufferedImageSink bufferedImageSink = new BufferedImageSink();
                        try {
                            Thumbnailator.createThumbnail(new SourceSinkThumbnailTask(Builder.this.makeParam(), imageSource, bufferedImageSink));
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                        return bufferedImageSink.getSink();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove elements from this iterator.");
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class BufferedImageImageSourceIterator
        implements Iterable<ImageSource<BufferedImage>> {
            private final Iterable<BufferedImage> image;

            private BufferedImageImageSourceIterator(Iterable<BufferedImage> iterable) {
                this.image = iterable;
            }

            @Override
            public Iterator<ImageSource<BufferedImage>> iterator() {
                return new Iterator<ImageSource<BufferedImage>>(){
                    Iterator<BufferedImage> iter;
                    {
                        this.iter = BufferedImageImageSourceIterator.this.image.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<BufferedImage> next() {
                        return new BufferedImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class InputStreamImageSourceIterator
        implements Iterable<ImageSource<InputStream>> {
            private final Iterable<? extends InputStream> inputStreams;

            private InputStreamImageSourceIterator(Iterable<? extends InputStream> iterable) {
                this.inputStreams = iterable;
            }

            @Override
            public Iterator<ImageSource<InputStream>> iterator() {
                return new Iterator<ImageSource<InputStream>>(){
                    Iterator<? extends InputStream> iter;
                    {
                        this.iter = InputStreamImageSourceIterator.this.inputStreams.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<InputStream> next() {
                        return new InputStreamImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class URLImageSourceIterator
        implements Iterable<ImageSource<URL>> {
            private final Iterable<URL> urls;

            private URLImageSourceIterator(Iterable<URL> iterable) {
                this.urls = iterable;
            }

            @Override
            public Iterator<ImageSource<URL>> iterator() {
                return new Iterator<ImageSource<URL>>(){
                    Iterator<URL> iter;
                    {
                        this.iter = URLImageSourceIterator.this.urls.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<URL> next() {
                        return new URLImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class FileImageSourceIterator
        implements Iterable<ImageSource<File>> {
            private final Iterable<File> files;

            private FileImageSourceIterator(Iterable<File> iterable) {
                this.files = iterable;
            }

            @Override
            public Iterator<ImageSource<File>> iterator() {
                return new Iterator<ImageSource<File>>(){
                    Iterator<File> iter;
                    {
                        this.iter = FileImageSourceIterator.this.files.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<File> next() {
                        return new FileImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class StringImageSourceIterator
        implements Iterable<ImageSource<File>> {
            private final Iterable<String> filenames;

            private StringImageSourceIterator(Iterable<String> iterable) {
                this.filenames = iterable;
            }

            @Override
            public Iterator<ImageSource<File>> iterator() {
                return new Iterator<ImageSource<File>>(){
                    Iterator<String> iter;
                    {
                        this.iter = StringImageSourceIterator.this.filenames.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public ImageSource<File> next() {
                        return new FileImageSource(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
    }
}

