/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.commons.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import net.guerlab.cloud.core.result.Pageable;
import net.guerlab.cloud.searchparams.SearchParams;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface Api<D, PK extends Serializable, SP extends SearchParams> {
    @Nullable
    @GetMapping(value={"/{id}"})
    @Operation(summary="\u901a\u8fc7Id\u67e5\u8be2\u5355\u4e00\u7ed3\u679c", security={@SecurityRequirement(name="Authorization")})
    public D selectById(@Parameter(description="\u4e3b\u952eID", required=true) @PathVariable(value="id") PK var1, @Nullable SP var2);

    @Nullable
    default public D selectById(PK id) {
        return this.selectById(id, null);
    }

    default public Optional<D> selectByIdOptional(PK id) {
        return Optional.ofNullable(this.selectById(id, null));
    }

    @Nullable
    @PostMapping(value={"/search/one"})
    @Operation(summary="\u67e5\u8be2\u5355\u4e00\u7ed3\u679c", security={@SecurityRequirement(name="Authorization")})
    public D selectOne(@Parameter(description="\u641c\u7d22\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody SP var1);

    default public Optional<D> selectOneOptional(SP searchParams) {
        return Optional.ofNullable(this.selectOne(searchParams));
    }

    @PostMapping(value={"/search/list"})
    @Operation(summary="\u67e5\u8be2\u5217\u8868", security={@SecurityRequirement(name="Authorization")})
    public Collection<D> selectList(@Parameter(description="\u641c\u7d22\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody SP var1);

    @PostMapping(value={"/search/page"})
    @Operation(summary="\u67e5\u8be2\u5206\u9875\u5217\u8868", security={@SecurityRequirement(name="Authorization")})
    public Pageable<D> selectPage(@Parameter(description="\u641c\u7d22\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody SP var1, @Parameter(description="\u5206\u9875ID") @RequestParam(name="pageId", defaultValue="1", required=false) int var2, @Parameter(description="\u5206\u9875\u5c3a\u5bf8") @RequestParam(name="pageSize", defaultValue="10", required=false) int var3);

    @PostMapping(value={"/search/count"})
    @Operation(summary="\u67e5\u8be2\u603b\u8bb0\u5f55\u6570", security={@SecurityRequirement(name="Authorization")})
    public int selectCount(@Parameter(description="\u641c\u7d22\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody SP var1);
}

