/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.commons.enums;

import java.util.EnumMap;
import java.util.concurrent.TimeUnit;

public enum TimeUnitMessageKey {
    NANOSECONDS(TimeUnit.NANOSECONDS, "time.nanoSeconds"),
    MICROSECONDS(TimeUnit.MICROSECONDS, "time.microSeconds"),
    MILLISECONDS(TimeUnit.MILLISECONDS, "time.milliSeconds"),
    SECONDS(TimeUnit.SECONDS, "time.seconds"),
    MINUTES(TimeUnit.MINUTES, "time.minutes"),
    HOURS(TimeUnit.HOURS, "time.hours"),
    DAYS(TimeUnit.DAYS, "time.days");

    private static final EnumMap<TimeUnit, String> KEY_MAP;
    private final TimeUnit timeUnit;
    private final String key;

    private TimeUnitMessageKey(TimeUnit timeUnit, String key) {
        this.timeUnit = timeUnit;
        this.key = key;
    }

    public static String getKey(TimeUnit timeUnit) {
        return KEY_MAP.get((Object)timeUnit);
    }

    public String getKey() {
        return this.key;
    }

    static {
        KEY_MAP = new EnumMap(TimeUnit.class);
        for (TimeUnitMessageKey value : TimeUnitMessageKey.values()) {
            KEY_MAP.put(value.timeUnit, value.key);
        }
    }
}

