/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.commons.ip;

import java.util.Objects;
import net.guerlab.cloud.commons.ip.IpRangeAddress;
import net.guerlab.cloud.commons.ip.IpType;
import net.guerlab.cloud.commons.ip.IpUtils;
import net.guerlab.cloud.commons.ip.Ipv4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ipv4RangeAddress
implements Ipv4,
IpRangeAddress {
    private static final Logger log = LoggerFactory.getLogger(Ipv4RangeAddress.class);
    private static final IpType IP_TYPE = IpType.IPV4_SEGMENT;
    private final long startAddress;
    private final long endAddress;
    private final long mask;
    private final int maskLength;

    Ipv4RangeAddress(long startAddress, long endAddress, long mask, int maskLength) {
        this.startAddress = startAddress;
        this.endAddress = endAddress;
        this.mask = mask;
        this.maskLength = maskLength;
    }

    Ipv4RangeAddress(long startAddress, long endAddress) {
        this(startAddress, endAddress, IpUtils.calculationIpv4Mask(startAddress, endAddress), -1);
    }

    @Override
    public IpType getIpType() {
        return IP_TYPE;
    }

    public String toString() {
        if (this.maskLength > 0) {
            return "Ipv4RangeAddress[ipWithMask=" + IpUtils.convertIpv4String(this.startAddress) + "/" + this.maskLength + "]";
        }
        return "Ipv4RangeAddress[start=" + IpUtils.convertIpv4String(this.startAddress) + ", end=" + IpUtils.convertIpv4String(this.endAddress) + ", mask=" + IpUtils.convertIpv4String(this.mask) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ipv4RangeAddress range = (Ipv4RangeAddress)o;
        return Objects.equals(this.startAddress, range.startAddress) && Objects.equals(this.endAddress, range.endAddress);
    }

    public int hashCode() {
        return Objects.hash(this.startAddress, this.endAddress);
    }

    @Override
    public long getStartAddress() {
        return this.startAddress;
    }

    @Override
    public long getEndAddress() {
        return this.endAddress;
    }

    public long getMask() {
        return this.mask;
    }

    public int getMaskLength() {
        return this.maskLength;
    }
}

