/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.commons.ip;

import java.util.Arrays;
import net.guerlab.cloud.commons.ip.Ipv4;
import net.guerlab.cloud.commons.ip.Ipv4Address;
import net.guerlab.cloud.commons.ip.Ipv4RangeAddress;
import org.apache.commons.lang3.StringUtils;

public class Ipv4Utils {
    private Ipv4Utils() {
    }

    public static boolean isIpv4(String ip) {
        return Ipv4Utils.isSingleIpv4(ip) || Ipv4Utils.isSegmentIpv4(ip);
    }

    public static boolean isSingleIpv4(String ip) {
        return ip.matches("^(((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))(\\.((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))){3})$");
    }

    public static boolean isSegmentIpv4(String ip) {
        boolean hasRangeLinkFlag = ip.contains("-");
        boolean hasMaskFlag = ip.contains("/");
        if (!hasRangeLinkFlag && !hasMaskFlag) {
            return false;
        }
        if (!hasRangeLinkFlag) {
            return ip.matches("^((((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))(\\.((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))){3})(/((3[0-2])|([1-2]\\d)|([0]?[1-9])))?)$");
        }
        String[] addressArray = ip.split("-");
        if (addressArray.length != 2) {
            return false;
        }
        if (hasMaskFlag) {
            return Arrays.stream(addressArray).anyMatch(address -> address.matches("^((((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))(\\.((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))){3})(/((3[0-2])|([1-2]\\d)|([0]?[1-9])))?)$"));
        }
        boolean startMatch = addressArray[0].matches("^(((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))(\\.((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))){3})$");
        boolean endMatch = addressArray[1].matches("^(((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))\\.){0,3}(((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d)))$");
        return startMatch && endMatch;
    }

    public static Ipv4 parseIpv4(long address) {
        return new Ipv4Address(address);
    }

    public static Ipv4 parseIpv4(String address) {
        if ((address = StringUtils.trimToNull((String)address)) == null) {
            throw new IllegalArgumentException("address invalid");
        }
        boolean hasRangeLinkFlag = address.contains("-");
        boolean hasMaskFlag = address.contains("/");
        if (hasRangeLinkFlag && hasMaskFlag) {
            String[] addressArray = address.split("-");
            if (addressArray.length != 2) {
                throw new IllegalArgumentException("address is invalid");
            }
            Ipv4 start = Ipv4Utils.parseIpv4(addressArray[0]);
            Ipv4 end = Ipv4Utils.parseIpv4(addressArray[1]);
            return new Ipv4RangeAddress(start.getStartAddress(), end.getEndAddress());
        }
        if (hasRangeLinkFlag) {
            return Ipv4Utils.parseIpv4WithRangeLinkFlag(address);
        }
        if (hasMaskFlag) {
            return Ipv4Utils.parseIpv4WithMaskFlag(address);
        }
        return new Ipv4Address(address);
    }

    public static Ipv4RangeAddress parseIpv4WithRangeLinkFlag(String ipRange) {
        String[] ipRangeArray = ipRange.split("-", 2);
        long start = Ipv4Utils.parseIpv4Address(ipRangeArray[0]);
        String[] groupValues = ipRangeArray[1].split("\\.", 4);
        int length = groupValues.length;
        long baseAddress = start & 0xFFFFFFFFL << (length << 3);
        for (int offset = 0; offset < length; ++offset) {
            baseAddress += Ipv4Utils.parseIpv4GroupValue(groupValues[offset]) << (length - offset - 1 << 3);
        }
        return new Ipv4RangeAddress(start, baseAddress);
    }

    public static Ipv4RangeAddress parseIpv4WithMaskFlag(String ipRange) {
        String[] ipRangeArray = ipRange.split("/", 2);
        if (!ipRangeArray[1].matches("^((3[0-2])|([1-2]\\d)|([0]?[1-9]))$")) {
            throw new IllegalArgumentException("illegal arguments");
        }
        int maskLength = Integer.parseInt(ipRangeArray[1]);
        long tmp = Ipv4Utils.parseIpv4Address(ipRangeArray[0]);
        Ipv4Address subNetMask = Ipv4Utils.computeIpv4MaskFromNetworkPrefix(maskLength);
        Ipv4Address subNet = new Ipv4Address(subNetMask.getIpAddress() & tmp);
        Ipv4Address start = new Ipv4Address(subNet.getIpAddress());
        Ipv4Address end = new Ipv4Address(subNet.getIpAddress() + (1L << 32 - maskLength) - 1L);
        return new Ipv4RangeAddress(start.getStartAddress(), end.getIpAddress(), subNetMask.getIpAddress(), maskLength);
    }

    private static long parseIpv4GroupValue(String str) {
        if (!str.matches("^((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))$")) {
            throw new IllegalArgumentException(str + " is invalid");
        }
        return Long.parseLong(str);
    }

    public static Ipv4Address computeIpv4MaskFromNetworkPrefix(int prefix) {
        String str = "1".repeat(prefix) + "0".repeat(32 - prefix);
        return new Ipv4Address(Long.parseLong(str, 2));
    }

    public static long calculationIpv4Mask(long startAddress, long endAddress) {
        long mask = 0L;
        for (int i = 0; i < 4; ++i) {
            int offset = i << 3;
            mask += ((startAddress >> offset & 0xFFL ^ endAddress >> offset & 0xFFL ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFL) << offset;
        }
        return mask;
    }

    public static String convertIpv4String(long ipAddress) {
        return String.format("%d.%d.%d.%d", ipAddress >> 24 & 0xFFL, ipAddress >> 16 & 0xFFL, ipAddress >> 8 & 0xFFL, ipAddress & 0xFFL);
    }

    public static long parseIpv4Address(String ipAddressStr) {
        if ((ipAddressStr = StringUtils.trimToNull((String)ipAddressStr)) == null) {
            throw new IllegalArgumentException();
        }
        long offset = 24L;
        long result = 0L;
        for (String valStr : ipAddressStr.split("\\.", 4)) {
            if (!valStr.matches("^((25[0-5])|(2[0-4]\\d)|([0-1]?\\d?\\d))$")) {
                throw new IllegalArgumentException("Invalid IP Address [" + ipAddressStr + "]");
            }
            result += Long.parseLong(valStr) << (int)offset;
            offset -= 8L;
        }
        return result;
    }
}

