/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.commons.util;

import java.util.Collection;
import java.util.List;
import net.guerlab.cloud.core.dto.Convert;
import net.guerlab.cloud.core.result.Pageable;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.exception.ApplicationException;
import org.springframework.beans.BeanUtils;
import org.springframework.lang.Nullable;

public class BeanConvertUtils {
    private BeanConvertUtils() {
    }

    @Nullable
    public static <T, E extends Convert<T>> T toObject(@Nullable E entity) {
        return (T)(entity == null ? null : entity.convert());
    }

    @Nullable
    public static <T, E> T toObject(@Nullable E entity, Class<T> targetClass) {
        T target;
        if (entity == null) {
            return null;
        }
        try {
            target = targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
        BeanUtils.copyProperties(entity, target);
        return target;
    }

    public static <T, E extends Convert<T>> List<T> toList(Collection<E> entityList) {
        return CollectionUtil.toList(entityList, Convert::convert);
    }

    public static <T, E> List<T> toList(Collection<E> entityList, Class<T> targetClass) {
        return CollectionUtil.toList(entityList, (T e) -> BeanConvertUtils.toObject(e, targetClass));
    }

    public static <T, E extends Convert<T>> Pageable<T> toPageable(@Nullable Pageable<E> list) {
        if (list == null || CollectionUtil.isEmpty((Collection)list.getList())) {
            return Pageable.empty();
        }
        Pageable<T> result = BeanConvertUtils.copyPageable(list);
        result.setList(BeanConvertUtils.toList(list.getList()));
        return result;
    }

    public static <T, E> Pageable<T> toPageable(@Nullable Pageable<E> list, Class<T> dtoClass) {
        if (list == null || CollectionUtil.isEmpty((Collection)list.getList())) {
            return Pageable.empty();
        }
        Pageable<T> result = BeanConvertUtils.copyPageable(list);
        result.setList(BeanConvertUtils.toList(list.getList(), dtoClass));
        return result;
    }

    private static <T> Pageable<T> copyPageable(Pageable<?> origin) {
        Pageable result = new Pageable();
        result.setPageSize(origin.getPageSize());
        result.setCount(origin.getCount());
        result.setCurrentPageId(origin.getCurrentPageId());
        result.setMaxPageId(origin.getMaxPageId());
        return result;
    }
}

