/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.commons.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.cloud.commons.Constants;
import net.guerlab.cloud.commons.entity.IOrderlyEntity;
import net.guerlab.cloud.commons.entity.ITreeEntity;
import net.guerlab.commons.collection.CollectionUtil;

public class TreeUtils {
    private TreeUtils() {
    }

    public static <T extends ITreeEntity<T, Long>> List<T> tree(Collection<T> data) {
        return TreeUtils.tree(data, Constants.DEFAULT_PARENT_ID);
    }

    public static <T extends ITreeEntity<T, PK>, PK> List<T> tree(Collection<T> data, PK rootId) {
        if (CollectionUtil.isEmpty(data)) {
            return Collections.emptyList();
        }
        Map map = CollectionUtil.toMap(data, ITreeEntity::id);
        Map childrenMap = CollectionUtil.group(data, ITreeEntity::parentId);
        List roots = (List)childrenMap.get(rootId);
        if (CollectionUtil.isEmpty((Collection)roots)) {
            return Collections.emptyList();
        }
        childrenMap.forEach((parentId, list) -> {
            list.sort((o1, o2) -> {
                if (o1 instanceof IOrderlyEntity && o2 instanceof IOrderlyEntity) {
                    return IOrderlyEntity.compareTo((IOrderlyEntity)((Object)o1), (IOrderlyEntity)((Object)o2));
                }
                return 0;
            });
            ITreeEntity parent = (ITreeEntity)map.get(parentId);
            if (parent != null) {
                parent.setChildren(list);
            }
        });
        return roots;
    }
}

