/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.commons.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.guerlab.commons.random.RandomUtil;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;
import org.springframework.lang.Nullable;

public class TwoFactorAuthentication {
    private static final int SECRET_SIZE = 10;
    private static final int SEED_LENGTH = 76;
    private static final String RANDOM_NUMBER_ALGORITHM = "SHA1PRNG";
    private static final String OTP_QR_CODE_FORMAT = "otpauth://totp/%s?secret=%s";
    private static final int DATA_DEVIATION = 8;
    private static final String VERIFY_CODE_ALGORITHM = "HmacSHA1";
    private static final int TRUNCATED_HASH_CALCULATION_FREQUENCY = 4;
    private static final String OPT_FORMAT = "%06d";

    private TwoFactorAuthentication() {
    }

    @Nullable
    public static String generateSecretKey() {
        try {
            SecureRandom sr = SecureRandom.getInstance(RANDOM_NUMBER_ALGORITHM);
            sr.setSeed(Base64.decodeBase64((String)RandomUtil.nextString((int)76)));
            byte[] buffer = sr.generateSeed(10);
            byte[] bEncodedKey = new Base32().encode(buffer);
            return new String(bEncodedKey);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String getQrCode(String user, String secret) {
        return String.format(OTP_QR_CODE_FORMAT, user, secret);
    }

    public static boolean checkCode(String secret, String code) {
        return TwoFactorAuthentication.checkCode(secret, code, System.currentTimeMillis());
    }

    public static boolean checkCode(String secret, String code, long millisecond) {
        return TwoFactorAuthentication.checkCode(secret, code, millisecond, 1);
    }

    public static boolean checkCode(String secret, String code, long millisecond, int windowSize) {
        byte[] decodedKey = new Base32().decode(secret);
        long t = millisecond / 1000L / 30L;
        for (int i = -Math.abs(windowSize); i <= windowSize; ++i) {
            try {
                String tempCode = TwoFactorAuthentication.verifyCode(decodedKey, t + (long)i);
                if (!Objects.equals(tempCode, code)) continue;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static String verifyCode(byte[] key, long t) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] data = new byte[8];
        long value = t;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, VERIFY_CODE_ALGORITHM);
        Mac mac = Mac.getInstance(VERIFY_CODE_ALGORITHM);
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return String.format(OPT_FORMAT, (int)(truncatedHash %= 1000000L));
    }
}

