/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.function.Supplier;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.internal.util.Assert;

public class Execution
extends AbstractExecution {
    public Execution(Policy ... policies) {
        super(new FailsafeExecutor<Object>(policies));
    }

    Execution(FailsafeExecutor<?> executor) {
        super(executor);
    }

    public boolean canRetryFor(Object result) {
        return !this.postExecute(new ExecutionResult(result, null));
    }

    public boolean canRetryFor(Object result, Throwable failure) {
        return !this.postExecute(new ExecutionResult(result, failure));
    }

    public boolean canRetryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        return !this.postExecute(new ExecutionResult(null, failure));
    }

    public void complete() {
        this.postExecute(ExecutionResult.NONE);
    }

    public boolean complete(Object result) {
        return this.postExecute(new ExecutionResult(result, null));
    }

    public boolean recordFailure(Throwable failure) {
        return this.canRetryOn(failure);
    }

    ExecutionResult executeSync(Supplier<ExecutionResult> supplier) {
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            supplier = policyExecutor.supply(supplier);
        }
        ExecutionResult result = supplier.get();
        this.completed = result.isComplete();
        this.executor.handleComplete(result, this);
        return result;
    }
}

