/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.FailurePolicy;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.event.ExecutionCompletedEvent;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.internal.EventListener;
import net.jodah.failsafe.internal.executor.RetryPolicyExecutor;
import net.jodah.failsafe.internal.util.Assert;

public class RetryPolicy<R>
extends FailurePolicy<RetryPolicy<R>, R> {
    private static final int DEFAULT_MAX_RETRIES = 2;
    static final RetryPolicy NEVER = new RetryPolicy().withMaxRetries(0);
    private Duration delay;
    private Duration delayMin;
    private Duration delayMax;
    private double delayFactor;
    private Duration maxDelay;
    private DelayFunction<R, ? extends Throwable> delayFn;
    private Object delayResult;
    private Class<? extends Throwable> delayFailure;
    private Duration jitter;
    private double jitterFactor;
    private Duration maxDuration;
    private int maxRetries;
    private List<BiPredicate<R, Throwable>> abortConditions;
    private EventListener abortListener;
    private EventListener failedAttemptListener;
    private EventListener retriesExceededListener;
    private EventListener retryListener;

    public RetryPolicy() {
        this.delay = Duration.ZERO;
        this.maxRetries = 2;
        this.abortConditions = new ArrayList<BiPredicate<R, Throwable>>();
    }

    private RetryPolicy(RetryPolicy<R> rp) {
        this.delay = rp.delay;
        this.delayMin = rp.delayMin;
        this.delayMax = rp.delayMax;
        this.delayFactor = rp.delayFactor;
        this.maxDelay = rp.maxDelay;
        this.delayFn = rp.delayFn;
        this.delayResult = rp.delayResult;
        this.delayFailure = rp.delayFailure;
        this.maxDuration = rp.maxDuration;
        this.maxRetries = rp.maxRetries;
        this.jitter = rp.jitter;
        this.jitterFactor = rp.jitterFactor;
        this.failuresChecked = rp.failuresChecked;
        this.failureConditions = new ArrayList(rp.failureConditions);
        this.abortConditions = new ArrayList<BiPredicate<R, Throwable>>(rp.abortConditions);
        this.abortListener = rp.abortListener;
        this.failedAttemptListener = rp.failedAttemptListener;
        this.retriesExceededListener = rp.retriesExceededListener;
        this.retryListener = rp.retryListener;
    }

    public RetryPolicy<R> abortIf(BiPredicate<R, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.abortConditions.add(completionPredicate);
        return this;
    }

    public RetryPolicy<R> abortIf(Predicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.abortConditions.add(RetryPolicy.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicy<R> abortOn(Class<? extends Throwable> failure) {
        Assert.notNull(failure, "failure");
        return this.abortOn(Arrays.asList(failure));
    }

    public RetryPolicy<R> abortOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.abortOn(Arrays.asList(failures));
    }

    public RetryPolicy<R> abortOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.abortConditions.add(RetryPolicy.failurePredicateFor(failures));
        return this;
    }

    public RetryPolicy<R> abortOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.abortConditions.add(RetryPolicy.failurePredicateFor(failurePredicate));
        return this;
    }

    public RetryPolicy<R> abortWhen(R result) {
        this.abortConditions.add(RetryPolicy.resultPredicateFor(result));
        return this;
    }

    public boolean allowsRetries() {
        return !(this.maxRetries != -1 && this.maxRetries <= 0 || this.maxDuration != null && this.maxDuration.toNanos() <= 0L);
    }

    public boolean isAbortable(R result, Throwable failure) {
        for (BiPredicate<R, Throwable> predicate : this.abortConditions) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public RetryPolicy<R> onAbort(CheckedConsumer<? extends ExecutionCompletedEvent<R>> listener) {
        this.abortListener = EventListener.of(Assert.notNull(listener, "listener"));
        return this;
    }

    public RetryPolicy<R> onFailedAttempt(CheckedConsumer<? extends ExecutionAttemptedEvent<R>> listener) {
        this.failedAttemptListener = EventListener.ofAttempt(Assert.notNull(listener, "listener"));
        return this;
    }

    public RetryPolicy<R> onRetriesExceeded(CheckedConsumer<? extends ExecutionCompletedEvent<R>> listener) {
        this.retriesExceededListener = EventListener.of(Assert.notNull(listener, "listener"));
        return this;
    }

    public RetryPolicy<R> onRetry(CheckedConsumer<? extends ExecutionAttemptedEvent<R>> listener) {
        this.retryListener = EventListener.ofAttempt(Assert.notNull(listener, "listener"));
        return this;
    }

    public boolean canApplyDelayFn(R result, Throwable failure) {
        return (this.delayResult == null || this.delayResult.equals(result)) && (this.delayFailure == null || failure != null && this.delayFailure.isAssignableFrom(failure.getClass()));
    }

    public RetryPolicy<R> copy() {
        return new RetryPolicy<R>(this);
    }

    public Duration getDelay() {
        return this.delay;
    }

    public Duration getDelayMin() {
        return this.delayMin;
    }

    public Duration getDelayMax() {
        return this.delayMax;
    }

    public DelayFunction<R, ? extends Throwable> getDelayFn() {
        return this.delayFn;
    }

    public double getDelayFactor() {
        return this.delayFactor;
    }

    public Duration getJitter() {
        return this.jitter;
    }

    public double getJitterFactor() {
        return this.jitterFactor;
    }

    public int getMaxAttempts() {
        return this.maxRetries == -1 ? -1 : this.maxRetries + 1;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public RetryPolicy<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit) {
        return this.withBackoff(delay, maxDelay, chronoUnit, 2.0);
    }

    public RetryPolicy<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit, double delayFactor) {
        Assert.notNull(chronoUnit, "chronoUnit");
        Assert.isTrue(delay > 0L, "The delay must be greater than 0", new Object[0]);
        Duration delayDuration = Duration.of(delay, chronoUnit);
        Duration maxDelayDuration = Duration.of(maxDelay, chronoUnit);
        Assert.state(this.maxDuration == null || delayDuration.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        Assert.isTrue(delayDuration.toNanos() < maxDelayDuration.toNanos(), "delay must be less than the maxDelay", new Object[0]);
        Assert.isTrue(delayFactor > 1.0, "delayFactor must be greater than 1", new Object[0]);
        Assert.state(this.delay == null || this.delay.equals(Duration.ZERO), "Delays have already been set", new Object[0]);
        Assert.state(this.delayMin == null, "Random delays have already been set", new Object[0]);
        this.delay = delayDuration;
        this.maxDelay = maxDelayDuration;
        this.delayFactor = delayFactor;
        return this;
    }

    public RetryPolicy<R> withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        Assert.isTrue(delay.toNanos() > 0L, "delay must be greater than 0", new Object[0]);
        Assert.state(this.maxDuration == null || delay.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        Assert.state(this.delayMin == null, "Random delays have already been set", new Object[0]);
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        this.delay = delay;
        return this;
    }

    public RetryPolicy<R> withDelay(long delayMin, long delayMax, ChronoUnit chronoUnit) {
        Assert.notNull(chronoUnit, "chronoUnit");
        Assert.isTrue(delayMin > 0L, "delayMin must be greater than 0", new Object[0]);
        Assert.isTrue(delayMax > 0L, "delayMax must be greater than 0", new Object[0]);
        Duration delayMinDuration = Duration.of(delayMin, chronoUnit);
        Duration delayMaxDuration = Duration.of(delayMax, chronoUnit);
        Assert.isTrue(delayMinDuration.toNanos() < delayMaxDuration.toNanos(), "delayMin must be less than delayMax", new Object[0]);
        Assert.state(this.maxDuration == null || delayMaxDuration.toNanos() < this.maxDuration.toNanos(), "delayMax must be less than the maxDuration", new Object[0]);
        Assert.state(this.delay == null || this.delay.equals(Duration.ZERO), "Delays have already been set", new Object[0]);
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        this.delayMin = delayMinDuration;
        this.delayMax = delayMaxDuration;
        return this;
    }

    public RetryPolicy<R> withDelay(DelayFunction<R, ? extends Throwable> delayFunction) {
        Assert.notNull(delayFunction, "delayFunction");
        this.delayFn = delayFunction;
        return this;
    }

    public <F extends Throwable> RetryPolicy<R> withDelayOn(DelayFunction<R, F> delayFunction, Class<F> failure) {
        this.withDelay(delayFunction);
        Assert.notNull(failure, "failure");
        this.delayFailure = failure;
        return this;
    }

    public RetryPolicy<R> withDelayWhen(DelayFunction<R, ? extends Throwable> delayFunction, R result) {
        this.withDelay(delayFunction);
        Assert.notNull(result, "result");
        this.delayResult = result;
        return this;
    }

    public RetryPolicy<R> withJitter(double jitterFactor) {
        Assert.isTrue(jitterFactor >= 0.0 && jitterFactor <= 1.0, "jitterFactor must be >= 0 and <= 1", new Object[0]);
        Assert.state(this.delay != null || this.delayMin != null, "A delay must be configured", new Object[0]);
        Assert.state(this.jitter == null, "withJitter(Duration) has already been called", new Object[0]);
        this.jitterFactor = jitterFactor;
        return this;
    }

    public RetryPolicy<R> withJitter(Duration jitter) {
        Assert.notNull(jitter, "jitter");
        Assert.isTrue(jitter.toNanos() > 0L, "jitter must be > 0", new Object[0]);
        Assert.state(this.delay != null || this.delayMin != null, "A delay must be configured", new Object[0]);
        Assert.state(this.jitterFactor == 0.0, "withJitter(double) has already been called", new Object[0]);
        Assert.state(jitter.toNanos() <= this.delay.toNanos(), "jitter must be less than the configured delay", new Object[0]);
        this.jitter = jitter;
        return this;
    }

    public RetryPolicy<R> withMaxAttempts(int maxAttempts) {
        Assert.isTrue(maxAttempts != 0, "maxAttempts cannot be 0", new Object[0]);
        Assert.isTrue(maxAttempts >= -1, "maxAttempts cannot be less than -1", new Object[0]);
        this.maxRetries = maxAttempts == -1 ? -1 : maxAttempts - 1;
        return this;
    }

    public RetryPolicy<R> withMaxDuration(Duration maxDuration) {
        Assert.notNull(maxDuration, "maxDuration");
        Assert.state(maxDuration.toNanos() > this.delay.toNanos(), "maxDuration must be greater than the delay", new Object[0]);
        this.maxDuration = maxDuration;
        return this;
    }

    public RetryPolicy<R> withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "maxRetries must be greater than or equal to -1", new Object[0]);
        this.maxRetries = maxRetries;
        return this;
    }

    @Override
    public PolicyExecutor toExecutor(AbstractExecution execution) {
        return new RetryPolicyExecutor(this, execution, this.abortListener, this.failedAttemptListener, this.retriesExceededListener, this.retryListener);
    }

    @FunctionalInterface
    public static interface DelayFunction<R, F extends Throwable> {
        public Duration computeDelay(R var1, F var2, ExecutionContext var3);
    }
}

