/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.internal.CircuitBreakerStats;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.internal.util.CircularBitSet;
import net.jodah.failsafe.util.Ratio;

public class HalfOpenState
extends CircuitState {
    private final CircuitBreaker circuit;

    public HalfOpenState(CircuitBreaker circuit) {
        this.circuit = circuit;
        this.setSuccessThreshold(circuit.getSuccessThreshold() != null ? circuit.getSuccessThreshold() : (circuit.getFailureThreshold() != null ? circuit.getFailureThreshold() : ONE_OF_ONE));
    }

    @Override
    public boolean allowsExecution(CircuitBreakerStats stats) {
        return stats.getCurrentExecutions() < this.maxConcurrentExecutions();
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.HALF_OPEN;
    }

    @Override
    public synchronized void recordFailure() {
        this.bitSet.setNext(false);
        this.checkThreshold();
    }

    @Override
    public synchronized void recordSuccess() {
        this.bitSet.setNext(true);
        this.checkThreshold();
    }

    @Override
    public void setFailureThreshold(Ratio threshold) {
        if (this.circuit.getSuccessThreshold() == null) {
            this.bitSet = new CircularBitSet(threshold.getDenominator(), this.bitSet);
        }
    }

    @Override
    public void setSuccessThreshold(Ratio threshold) {
        this.bitSet = new CircularBitSet(threshold.getDenominator(), this.bitSet);
    }

    synchronized void checkThreshold() {
        Ratio successRatio = this.circuit.getSuccessThreshold();
        Ratio failureRatio = this.circuit.getFailureThreshold();
        if (successRatio != null) {
            if (this.bitSet.occupiedBits() == successRatio.getDenominator() || successRatio.getValue() == 1.0 && this.bitSet.positiveRatioValue() < 1.0) {
                if (this.bitSet.positiveRatioValue() >= successRatio.getValue()) {
                    this.circuit.close();
                } else {
                    this.circuit.open();
                }
            }
        } else if (failureRatio != null) {
            if (this.bitSet.occupiedBits() == failureRatio.getDenominator() || failureRatio.getValue() == 1.0 && this.bitSet.negativeRatioValue() < 1.0) {
                if (this.bitSet.negativeRatioValue() >= failureRatio.getValue()) {
                    this.circuit.open();
                } else {
                    this.circuit.close();
                }
            }
        } else if (this.bitSet.positiveRatioValue() == 1.0) {
            this.circuit.close();
        } else {
            this.circuit.open();
        }
    }

    int maxConcurrentExecutions() {
        if (this.circuit.getSuccessThreshold() != null) {
            return this.circuit.getSuccessThreshold().getDenominator();
        }
        if (this.circuit.getFailureThreshold() != null) {
            return this.circuit.getFailureThreshold().getDenominator();
        }
        return 1;
    }
}

